/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.language;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.activity.language.contract.LanguageSettingsContract;
import com.zoyi.channel.plugin.android.base.AbstractPresenter;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;

public class LanguageSettingsPresenter
extends AbstractPresenter<LanguageSettingsContract.View>
implements LanguageSettingsContract.Presenter {
    public LanguageSettingsPresenter(LanguageSettingsContract.View view) {
        super(view);
    }

    @Override
    public void init() {
    }

    @Override
    public void changeLocale(final CHLocale locale) {
        ((LanguageSettingsContract.View)this.view).showProgress(locale);
        Api.touch(locale.toString()).cancelBy(ActionType.SHUTDOWN).runBy(ActionType.CHANGE_LANGUAGE).run(new RestSubscriber<GuestWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ((LanguageSettingsContract.View)LanguageSettingsPresenter.this.view).hideProgress();
            }

            @Override
            public void onSuccess(@NonNull GuestWrapper repo) {
                ((LanguageSettingsContract.View)LanguageSettingsPresenter.this.view).hideProgress();
                GuestStore.get().guest.set(repo.getGuest());
                SettingsStore.get().locale.set(locale);
                ((LanguageSettingsContract.View)LanguageSettingsPresenter.this.view).onLanguageChange(locale);
            }
        });
    }
}

