/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.NewMessageAlertView;
import com.zoyi.channel.plugin.android.activity.chat3.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat3.ChatPresenter;
import com.zoyi.channel.plugin.android.activity.chat3.KeyboardUtils;
import com.zoyi.channel.plugin.android.activity.chat3.contract.ChatContract;
import com.zoyi.channel.plugin.android.activity.chat3.listener.MessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat3.listener.OnProfileUpdateRequestListener;
import com.zoyi.channel.plugin.android.activity.chat3.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat3.navigation.HostHeaderView;
import com.zoyi.channel.plugin.android.activity.chat3.view.ChatInputView;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.navigation.ChannelInfoNavigationView;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.ChatStore;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.ProfileBotStore;
import com.zoyi.channel.plugin.android.store2.TranslationStore;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.PushBotSaveButton;
import com.zoyi.channel.plugin.android.view.scrollview.RecyclerBottomPlaceholderLayout;
import java.util.List;

public class ChatActivity
extends BaseActivity2
implements ChatContract.View,
OnMessageContentClickListener,
MessageActionListener,
OnProfileUpdateRequestListener {
    private NavigationView navigation;
    private ChannelInfoNavigationView channelHeader;
    private HostHeaderView hostHeader;
    private View layoutContent;
    private View layoutProgress;
    private ErrorRefreshView layoutError;
    private ChatInputView inputView;
    private RecyclerView recyclerView;
    private NewMessageAlertView newMessageAlertView;
    private RecyclerBottomPlaceholderLayout bottomPlaceholder;
    private PushBotSaveButton buttonPushBotSave;
    private ChatStartButton buttonNewChat;
    private ChatAdapter adapter;
    private LinearLayoutManager layoutManager;
    private ChatContract.Presenter presenter;
    @Nullable
    private KeyboardUtils keyboardUtils;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_chat3);
        Intent intent = this.getIntent();
        ChatContentType contentType = ChatContentType.NONE;
        String contentId = null;
        if (intent != null) {
            contentType = ChatContentType.fromString(intent.getStringExtra("chatContentType"));
            contentId = intent.getStringExtra("chatContentId");
        }
        this.navigation = (NavigationView)this.findViewById(R.id.navigationChat);
        this.navigation.addAction(R.drawable.ch_plugin_close_white, v -> Action.invoke(ActionType.EXIT));
        this.channelHeader = (ChannelInfoNavigationView)this.findViewById(R.id.navigationChatChannel);
        this.hostHeader = (HostHeaderView)this.findViewById(R.id.navigationChatHost);
        this.hostHeader.setVisibility(8);
        this.layoutContent = this.findViewById(R.id.layoutChatContent);
        this.layoutProgress = this.findViewById(R.id.layoutChatProgress);
        this.layoutError = (ErrorRefreshView)this.findViewById(R.id.layoutChatError);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerViewChat);
        this.newMessageAlertView = (NewMessageAlertView)this.findViewById(R.id.viewNewMessageAlert);
        this.newMessageAlertView.setListener(() -> {
            this.scrollToBottom();
            this.newMessageAlertView.hide();
        });
        this.inputView = (ChatInputView)this.findViewById(R.id.viewChatInput);
        this.inputView.setMessageActionListener(this);
        this.adapter = new ChatAdapter();
        this.adapter.setOnMessageContentClickListener(this);
        this.adapter.setOnProfileUpdateRequestListener(this);
        this.presenter = new ChatPresenter(this, this.adapter, this.adapter, contentType, contentId);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, 1, this.recyclerView){

            @Override
            public void scrolledInList() {
            }

            @Override
            public void scrollAttachedToBottom() {
                ChatActivity.this.newMessageAlertView.hide();
            }

            @Override
            public void refresh() {
                ChatActivity.this.presenter.fetchBackwardMessages();
            }
        });
        this.bottomPlaceholder = (RecyclerBottomPlaceholderLayout)this.findViewById(R.id.bottomLayoutChat);
        this.bottomPlaceholder.setRecyclerView(this.recyclerView);
        this.bottomPlaceholder.setStackFromEnd(true);
        this.buttonPushBotSave = (PushBotSaveButton)this.findViewById(R.id.buttonChatSavePushBot);
        this.buttonPushBotSave.setClickListener(v -> this.presenter.createPushBotChat());
        this.buttonNewChat = (ChatStartButton)this.findViewById(R.id.buttonChatStartNewChat);
        this.buttonNewChat.setOnClickListener(v -> this.finish(22, Transition.NONE));
        this.keyboardUtils = new KeyboardUtils(this, this.findViewById(R.id.rootChatCoordinatorView), this.recyclerView);
        this.keyboardUtils.enable();
        this.bindPresenter(this.presenter);
        GlobalStore.get().activeChatActivity.set(this);
        return true;
    }

    protected void onPause() {
        super.onPause();
        if (this.isFinishing()) {
            ChatStore.get().reset();
            TranslationStore.get().reset();
            ProfileBotStore.get().reset();
            ChatActivity chatActivity = GlobalStore.get().activeChatActivity.get();
            if (this == chatActivity) {
                GlobalStore.get().activeChatActivity.set(null);
            }
            Action.invoke(ActionType.CHAT_CLOSED);
        }
    }

    protected void onStop() {
        super.onStop();
        KeyboardUtils.hideKeyboard((Activity)this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.keyboardUtils != null) {
            this.keyboardUtils.disable();
            this.keyboardUtils = null;
        }
    }

    @Override
    public void onFetchStateChange(FetchState fetchState) {
        this.layoutContent.setVisibility(8);
        this.layoutProgress.setVisibility(8);
        this.layoutError.setVisibility(8);
        switch (fetchState) {
            case LOADING: {
                this.layoutProgress.setVisibility(0);
                break;
            }
            case FAILED: {
                this.layoutError.setVisibility(0);
                break;
            }
            case COMPLETE: {
                this.layoutContent.setVisibility(0);
            }
        }
    }

    @Override
    public void onWelcomeStateChange(ChatContentType contentType, boolean acceptInput) {
        this.channelHeader.setVisibility(0);
        this.hostHeader.setVisibility(8);
        this.buttonPushBotSave.setVisibility(8);
        this.buttonNewChat.setVisibility(8);
        switch (contentType) {
            case NONE: {
                this.inputView.setVisibility(0);
                this.inputView.setEnabled(acceptInput);
                break;
            }
            case SUPPORT_BOT_CHAT: {
                this.inputView.setVisibility(8);
                break;
            }
            case PUSH_BOT_CHAT: {
                this.inputView.setVisibility(8);
                this.buttonPushBotSave.setVisibility(0);
            }
        }
    }

    @Override
    public void setPushBotSaveButtonVisibility(boolean visible) {
        this.buttonPushBotSave.setVisibility(visible ? 0 : 8);
    }

    @Override
    public void onChatStateChange(UserChat userChat, boolean acceptInput, boolean temporaryInputOpened) {
        if (userChat.isStateRemoved()) {
            this.finish(Transition.NONE);
            return;
        }
        this.inputView.initUserChat(userChat.getId());
        if ("Manager".equals(userChat.getAssigneeType()) && userChat.getAssigneeId() != null) {
            this.channelHeader.setVisibility(8);
            this.hostHeader.setVisibility(0);
            this.hostHeader.attachUserChat(userChat.getId());
        } else {
            this.channelHeader.setVisibility(0);
            this.hostHeader.setVisibility(8);
        }
        this.buttonPushBotSave.setVisibility(8);
        if (userChat.isSupporting()) {
            Keyboard.close((Context)this, (View)this.inputView.getEditText());
            this.inputView.setVisibility(8);
            this.buttonNewChat.setVisibility(8);
        } else if (userChat.isStateClosed()) {
            Keyboard.close((Context)this, (View)this.inputView.getEditText());
            this.inputView.setVisibility(8);
            this.buttonNewChat.setVisibility(0);
        } else if (userChat.isStateSolved()) {
            if (temporaryInputOpened) {
                this.inputView.setVisibility(0);
                this.inputView.setEnabled(acceptInput);
                this.buttonNewChat.setVisibility(8);
            } else {
                Keyboard.close((Context)this, (View)this.inputView.getEditText());
                this.inputView.setVisibility(8);
                this.buttonNewChat.setVisibility(8);
            }
        } else {
            this.inputView.setVisibility(0);
            this.inputView.setEnabled(acceptInput);
            this.buttonNewChat.setVisibility(8);
        }
    }

    @Override
    public boolean isScrollOnBottom() {
        return !this.recyclerView.canScrollVertically(1);
    }

    @Override
    public void scrollToBottom() {
        this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
    }

    @Override
    public void showNewMessageAlert(ProfileEntity profileEntity) {
        this.newMessageAlertView.show(profileEntity);
    }

    @Override
    public void onTranslationButtonClick(Message message) {
        this.presenter.translate(message);
    }

    @Override
    public void onImageClick(File file) {
        if (file != null) {
            IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("fileId", file.getId()).startActivityForResult(3001);
        }
    }

    @Override
    public void onWebPageClick(String url) {
        if (url != null) {
            Executor.executeLinkAction((Context)this, url, LinkType.URL);
        }
    }

    @Override
    public void onFileClick(File file) {
        if (file != null) {
            if (file.getType() != null && file.getType().startsWith("video")) {
                IntentUtils.setNextActivity((Context)this, VideoViewerActivity.class).putExtra("filename", file.getName()).putExtra("url", file.getUrl()).startActivity();
            } else {
                IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", file.getUrl()).putExtra("filename", file.getFilename()).putExtra("image", file.isImage()).setTransition(Transition.NONE).startActivity();
            }
        }
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        this.presenter.onActionClick(actionType, actionButton);
    }

    @Override
    public void onResendButtonClick(SendingMessageItem item) {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString("ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString("ch.chat.retry_sending_message"), (dialog12, which) -> this.presenter.resend(item)).setNegativeButton((CharSequence)ResUtils.getString("ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString("ch.chat.delete"), (dialog1, which) -> this.presenter.removeFailedItem(item)).setCancelable(true).create();
        dialog.setOnShowListener(args -> {
            int dark = ContextCompat.getColor((Context)this, (int)R.color.ch_dark);
            int cobalt = ContextCompat.getColor((Context)this, (int)R.color.ch_cobalt);
            dialog.getButton(-1).setTextColor(cobalt);
            dialog.getButton(-2).setTextColor(dark);
            dialog.getButton(-3).setTextColor(dark);
        });
        dialog.show();
    }

    @Override
    public void onRedirectContentsClick(@Nullable String redirectUrl) {
        Executor.executeRedirectUrlAction((Context)this, redirectUrl);
    }

    @Override
    public void onLocalImageClick(@Nullable Previewable previewThumb) {
        if (previewThumb != null) {
            IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("localFileUrl", previewThumb.getUrl()).putExtra("localFileViewMode", true).startActivityForResult(3001);
        }
    }

    @Override
    public void onAttachmentButtonClick() {
        IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
    }

    @Override
    public void onSendClick(String message) {
        this.presenter.sendText(message);
    }

    @Override
    public void onCountrySelectorClick(ProfileBotMessageItem item) {
        this.presenter.requestCountries(item);
    }

    @Override
    public void showCountryDialog(List<Country> countries, ProfileBotMessageItem item) {
        new CountryCodeDialog((Context)this, countries, (position, countryCode) -> this.presenter.selectCountry(countryCode, item)).show();
    }

    @Override
    public void onProfileRequest(ProfileBotMessageItem item) {
        this.presenter.updateProfile(item);
    }

    @Override
    public void onProfileUpdateComplete() {
        this.inputView.setFocus();
    }

    @Override
    public void setInputDim(boolean enabled) {
        this.inputView.setInputDim(enabled);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.uploadFiles(data.getStringArrayListExtra("PHOTO_INTENT_KEY"));
            }
        }
    }
}

