/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.observers.SerializedObserver;
import com.zoyi.rx.subjects.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedSubject<T, R>
extends Subject<T, R> {
    private final SerializedObserver<T> observer;
    private final Subject<T, R> actual;

    public SerializedSubject(final Subject<T, R> actual) {
        super(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> child) {
                actual.unsafeSubscribe(child);
            }
        });
        this.actual = actual;
        this.observer = new SerializedObserver(actual);
    }

    @Override
    public void onCompleted() {
        this.observer.onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        this.observer.onError(e);
    }

    @Override
    public void onNext(T t) {
        this.observer.onNext(t);
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }
}

