package com.zoyi.channel.plugin.android.selector2;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.TimerStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder4;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.rx.functions.Action3;

public class BootDataSelector {

  public static Binder bindBootData(Action3<Plugin, Channel, Integer> action3) {
    State<Plugin> pluginState = PluginStore.get().pluginState;
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;
    State<CHLocale> localeState = SettingsStore.get().locale;

    return new Binder4<>(pluginState, channelState, nowState, localeState).bind((plugin, channel, now, locale) -> {
      if (plugin != null && channel != null) {
        action3.call(plugin, channel, ChannelUtils.getMinutesLeftToWork(channel, now));
      }
    });
  }
}
