package com.zoyi.channel.plugin.android.activity.settings2;

import com.zoyi.channel.plugin.android.action.ProfileBotSchemaAction;
import com.zoyi.channel.plugin.android.activity.settings2.contract.SettingsContract;
import com.zoyi.channel.plugin.android.base.AbstractPresenter;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector2.ProfileBotSelector;
import com.zoyi.channel.plugin.android.selector2.SettingsSelector;
import com.zoyi.channel.plugin.android.store2.PluginStore;

public class SettingsPresenter extends AbstractPresenter<SettingsContract.View> implements SettingsContract.Presenter {

  public SettingsPresenter(SettingsContract.View view) {
    super(view);
  }

  @Override
  public void init() {
    bind(SettingsSelector.bindLocale(locale -> view.onLocaleChange(locale)));

    bind(ProfileBotSelector.bindProfileSchemasFetchState(fetchState -> view.onProfileBotSchemasFetchStateChange(fetchState)));

    bind(ProfileBotSelector.bindProfileSchemas((profileBotSchemas, guest) -> view.onProfileBotSchemasChange(profileBotSchemas, guest)));

    fetchProfileBotSchema();
  }

  @Override
  public void fetchProfileBotSchema() {
    Plugin plugin = PluginStore.get().pluginState.get();

    if (plugin != null) {
      ProfileBotSchemaAction.getProfileBotSchemaAction(plugin.getId());
    }
  }
}
