package com.zoyi.channel.plugin.android.selector2;

import android.content.Context;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.store2.*;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder1;
import com.zoyi.channel.plugin.android.store2.binder.Binder2;
import com.zoyi.channel.plugin.android.store2.binder.Binder3;
import com.zoyi.channel.plugin.android.store2.state.BooleanState;
import com.zoyi.channel.plugin.android.store2.state.EntityMapState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action3;

public class GlobalSelector {

  public static Binder bindBootState(Action1<Boolean> action1) {
    return new Binder1<>(GlobalStore.get().bootState).bind(action1::call);
  }

  public static Binder bindMessengerVisibility(Action1<Boolean> action1) {
    return new Binder1<>(GlobalStore.get().messengerState).bind(action1);
  }

  public static Binder bindLauncherVisibility(Action1<Boolean> action1) {
    BooleanState bootState = GlobalStore.get().bootState;
    BooleanState showLauncherState = SettingsStore.get().showLauncher;

    return new Binder2<>(bootState, showLauncherState).bind((isBooted, showLauncher) ->
        action1.call(isBooted && showLauncher)
    );
  }

  private static boolean getLauncherVisibility(boolean showLauncher, Channel channel, Long now) {
    if (!showLauncher || now == null || channel == null) {
      return false;
    }
    boolean isWorking = ChannelUtils.getMinutesLeftToWork(channel, now) == 0;

    return isWorking || !Const.AWAY_OPTION_HIDDEN.equals(channel.getAwayOption());
  }

  public static boolean getLauncherVisibility() {
    return getLauncherVisibility(
        SettingsStore.get().showLauncher.get(),
        ChannelStore.get().channelState.get(),
        TimerStore.get().now.get()
    );
  }

  public static Binder bindInAppPush(Action1<InAppPushItem> action1) {
    State<InAppPushItem> inAppPushItemState = InAppPushStore.get().inAppPushItem;
    BooleanState hideInAppPushState = SettingsStore.get().hideDefaultInAppPush;

    return new Binder2<>(inAppPushItemState, hideInAppPushState).bind((inAppPushItem, hideInAppPush) -> {
      if (inAppPushItem != null && !hideInAppPush) {
        action1.call(inAppPushItem);
      } else {
        action1.call(null);
      }
    });
  }

  public static Binder bindLauncherStyle(Context context, Action3<Plugin, Integer, Boolean> action3) {
    State<Plugin> pluginState = PluginStore.get().pluginState;
    EntityMapState<PushBotItem> pushBotItemsState = PushBotStore.get().pushBots;
    State<Guest> guestState = GuestStore.get().guest;

    return new Binder3<>(
        pluginState,
        pushBotItemsState,
        guestState
    ).bind((plugin, pushBotItems, guest) -> {
      if (plugin != null) {
        int count = guest != null ? guest.getAlert() : 0;
        int pushBotCount = 0;
        boolean hasActivePushBot = false;

        for (PushBotItem pushBotItem : pushBotItems.values()) {
          if (pushBotItem.shouldShowToPopup() && ChannelUtils.isSameActivity(context, pushBotItem.getTargetActivity())) {
            hasActivePushBot = true;
          }
          if (pushBotItem.isActive()) {
            pushBotCount += pushBotItem.getAlertCount();
          }
        }

        action3.call(plugin, count + pushBotCount, hasActivePushBot);
      }
    });
  }
}
