/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import com.zoyi.channel.plugin.android.activity.photo_picker.OnPhotoClickListener;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerContract;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoDataSource;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoRepository;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.rx.Subscriber;
import java.util.ArrayList;

public class PhotoPickerPresenter
implements PhotoPickerContract.Presenter,
OnPhotoClickListener {
    private Context context;
    private PhotoPickerContract.View photoPickerView;
    private PhotoPickerAdapterContract.View adapterView;
    private PhotoPickerAdapterContract.Model adapterModel;
    private PhotoRepository photoRepository;

    public PhotoPickerPresenter(Context context) {
        this.context = context;
        this.photoRepository = new PhotoRepository(new PhotoDataSource());
    }

    @Override
    @Initializer
    public void setView(PhotoPickerContract.View view) {
        this.photoPickerView = view;
    }

    @Override
    @Initializer
    public void setAdapterView(PhotoPickerAdapterContract.View adapterView) {
        this.adapterView = adapterView;
        this.adapterView.setOnPhotoClickListener(this);
    }

    @Override
    @Initializer
    public void setAdapterModel(PhotoPickerAdapterContract.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void fetchPhotoItems() {
        this.photoRepository.getPhotoItems(this.context, new Subscriber<ArrayList<PhotoItem>>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
                PhotoPickerPresenter.this.photoPickerView.loadPhotoItems(new ArrayList<PhotoItem>());
            }

            public void onNext(ArrayList<PhotoItem> photoItems) {
                PhotoPickerPresenter.this.photoPickerView.loadPhotoItems(photoItems);
                PhotoPickerPresenter.this.adapterModel.setPhotoItems(photoItems);
            }
        });
    }

    @Override
    public void onPhotoClick(PhotoItem photoItem) {
        if (!this.adapterView.onPhotoItemClick(photoItem)) {
            this.photoPickerView.showLimitPopup();
        }
        this.photoPickerView.setMenuState(this.adapterModel.getSelectedPaths().size());
    }

    @Override
    public ArrayList<String> getSelectedPaths() {
        return this.adapterModel.getSelectedPaths();
    }
}

