/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerAdapter;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerContract;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerPresenter;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import java.util.ArrayList;

public class PhotoPickerActivity
extends BaseActivity
implements PhotoPickerContract.View {
    private LinearLayout emptyLayout;
    @Nullable
    private BigBar bigBar;
    private PhotoPickerContract.Presenter presenter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_photo_picker);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view_photo_picker);
        this.emptyLayout = (LinearLayout)this.findViewById(R.id.no_album);
        this.bigBar = this.getBigBar();
        if (this.bigBar != null) {
            this.bigBar.withActivity(this).setTitleByKey("ch.photo.all_images").addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.CAMERA, BigBar.MenuPosition.RIGHT).addMenu(MenuButton.ActionType.DONE, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.DISABLED).build();
        }
        PhotoPickerAdapter adapter = new PhotoPickerAdapter((Context)this);
        this.presenter = new PhotoPickerPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(adapter);
        this.presenter.setAdapterModel(adapter);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 3));
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        recyclerView.setItemAnimator(null);
        this.fetchPhotoItems();
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 3000: {
                    String photoPath = Executor.getPhotoPath();
                    if (!TextUtils.isEmpty((CharSequence)photoPath)) {
                        Executor.startFileMediaScan((Activity)this, photoPath);
                        this.sendPhotoPath(Executor.getPhotoPath());
                    }
                    return;
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void sendPhotoPath(String photoPath) {
        ArrayList<String> photoPaths = new ArrayList<String>();
        photoPaths.add(photoPath);
        this.sendPhotoPaths(photoPaths);
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        super.optionClicked(actionType);
        switch (actionType) {
            case BACK: {
                this.onBackPressed();
                break;
            }
            case CAMERA: {
                this.openCamera();
                break;
            }
            case DONE: {
                this.sendPhotoPaths(this.presenter.getSelectedPaths());
            }
        }
    }

    @Override
    public void showLimitPopup() {
        Toast.makeText((Context)this, (CharSequence)ResUtils.getString((Context)this, "ch.photo.limit_alert"), (int)1).show();
    }

    @Override
    public void loadPhotoItems(ArrayList<PhotoItem> photoItems) {
        this.setEmptyLayoutVisibility(photoItems.isEmpty());
    }

    @Override
    public void sendPhotoPaths(ArrayList<String> imagePaths) {
        Intent i = new Intent();
        i.putStringArrayListExtra("PHOTO_INTENT_KEY", imagePaths);
        this.setResult(12, i);
        this.finish();
    }

    @Override
    public void setMenuState(int selectedCount) {
        if (this.bigBar != null) {
            this.bigBar.setMenuState(MenuButton.ActionType.DONE, selectedCount > 0 ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.DISABLED);
        }
    }

    private void setEmptyLayoutVisibility(boolean visible) {
        this.emptyLayout.setVisibility(visible ? 0 : 8);
    }

    @Override
    protected void permissionAccepted(int requestCode) {
        switch (requestCode) {
            case 2: {
                this.fetchPhotoItemsPermissionAccepted();
                break;
            }
            case 3: {
                this.openCameraPermissionAccepted();
            }
        }
    }

    @Override
    protected void permissionRejected(int requestCode) {
        if (requestCode == 2) {
            this.finish();
        }
    }

    private void fetchPhotoItems() {
        if (this.checkPermission(2)) {
            this.fetchPhotoItemsPermissionAccepted();
        }
    }

    private void fetchPhotoItemsPermissionAccepted() {
        this.presenter.fetchPhotoItems();
    }

    private void openCamera() {
        if (!Utils.hasPermissionInManifest((Context)this, "android.permission.CAMERA")) {
            this.openCameraPermissionAccepted();
        } else if (this.checkPermission(3)) {
            this.openCameraPermissionAccepted();
        }
    }

    private void openCameraPermissionAccepted() {
        if (!Executor.takePhoto((Activity)this)) {
            Toast.makeText((Context)this, (CharSequence)ResUtils.getString((Context)this, "ch.permission.denied"), (int)1).show();
        }
    }
}

