/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapterContract2;
import com.zoyi.channel.plugin.android.activity.chat.ChatContract2;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.TypingManager;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.PushBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.enumerate.ChatState;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.event.ChannelModelBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.CountrySelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.PushBotSelector;
import com.zoyi.channel.plugin.android.selector.SupportBotSelector;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.store.ImageFileStore;
import com.zoyi.channel.plugin.android.store.PushBotItemStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.okhttp3.RequestBody;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatPresenter2
implements ChatContract2.Presenter,
OnMessageSendListener {
    @NonNull
    private ChatContract2.View view;
    @NonNull
    private ChatAdapterContract2.View adapterView;
    @NonNull
    private ChatAdapterContract2.Model adapterModel;
    @NonNull
    private TypingManager typingManager;
    @Nullable
    private String chatId;
    @Nullable
    private String pushBotId;
    @Nullable
    private UserChat userChat;
    @Nullable
    private Session session;
    @Nullable
    private String backwardId;
    @NonNull
    private List<Message> receiveMessagesWaitingQueue;
    @NonNull
    private List<SendingMessageItem> sendingMessagesWaitingQueue;
    private ChatState chatState = ChatState.IDLE;

    ChatPresenter2(@Nullable String chatId, @Nullable String pushBotId, @NonNull TypingManager typingManager) {
        TimeUtils.refreshOffset();
        this.chatId = chatId;
        this.pushBotId = pushBotId;
        this.typingManager = typingManager;
        this.receiveMessagesWaitingQueue = new ArrayList<Message>();
        this.sendingMessagesWaitingQueue = new ArrayList<SendingMessageItem>();
        ChatManager.get().addListener(this);
    }

    @Override
    @Initializer
    public void setView(@NonNull ChatContract2.View view) {
        this.view = view;
    }

    @Override
    @Initializer
    public void setAdapterView(@NonNull ChatAdapterContract2.View adapterView) {
        this.adapterView = adapterView;
    }

    @Override
    @Initializer
    public void setAdapterModel(@NonNull ChatAdapterContract2.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void release() {
        ChatManager.get().removeListener(this);
        if (this.chatId != null) {
            SocketManager.leaveChat(this.chatId);
        }
        this.cancelApis();
        Store.getInstance(ImageFileStore.class).clear();
        Store.getInstance(TranslationStore.class).clearData();
    }

    @Override
    public void init() {
        if (this.chatId != null) {
            this.chatState = ChatState.WAITING_SOCKET;
            this.typingManager.setChatId(this.chatId);
            this.checkSocketState();
        } else {
            this.view.showInitBanner();
            this.addInitMessage();
        }
    }

    private void addInitMessage() {
        PushBotItem pushBotItem = PushBotSelector.get(this.pushBotId);
        SupportBotEntry supportBotEntry = SupportBotSelector.getSupportBotEntry();
        if (pushBotItem != null) {
            pushBotItem.read();
            Store.getInstance(PushBotItemStore.class).add(pushBotItem);
            this.chatState = ChatState.LOCAL_PUSH_BOT;
            this.adapterModel.upsertInitMessage(new PushBotMessageItem(pushBotItem));
            this.view.setInputFrameVisibility(false);
            this.view.setPushBotSaveButtonVisibility(true);
        } else if (supportBotEntry != null) {
            this.chatState = ChatState.LOCAL_SUPPORTING;
            this.adapterModel.upsertInitMessage(new SupportBotMessageItem(supportBotEntry));
            this.view.setInputFrameVisibility(false);
        } else {
            this.chatState = ChatState.LOCAL_WELCOME;
            this.adapterModel.upsertInitMessage(new WelcomeMessageItem(PluginSelector.getWelcomeMessage(ChannelIO.getAppContext())));
            this.view.setInputFrameVisibility(true);
        }
    }

    @Override
    public void updateInitMessage() {
        if (this.chatId == null) {
            this.addInitMessage();
        }
    }

    @Override
    public void refresh() {
        this.view.onTryRefresh();
        switch (this.chatState) {
            case WAITING_SOCKET: {
                this.checkSocketState();
                break;
            }
            case USER_CHAT_NOT_LOADED: {
                this.fetchUserChat();
                break;
            }
            case INIT_MESSAGES_NOT_LOADED: {
                this.fetchInitMessages();
            }
        }
    }

    private void checkSocketState() {
        if (this.chatState == ChatState.WAITING_SOCKET && this.chatId != null) {
            if (SocketManager.isReady()) {
                this.chatState = ChatState.CHAT_JOINING;
                SocketManager.joinChat(this.chatId);
            } else {
                SocketManager.reconnect();
            }
        }
    }

    private void fetchUserChat() {
        if (this.chatId != null && CompareUtils.exists((Comparable)((Object)this.chatState), (Comparable[])new ChatState[]{ChatState.CHAT_JOINED, ChatState.USER_CHAT_NOT_LOADED})) {
            this.chatState = ChatState.USER_CHAT_LOADING;
            ChannelApiManager.callOnce("API_TAG_FETCH_USER_CHAT", ChannelApiManager.get().getUserChat(this.chatId), new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter2.this.chatState = ChatState.USER_CHAT_NOT_LOADED;
                    ChatPresenter2.this.view.onError();
                    L.e(error.getMessage());
                }

                @Override
                public void onSuccess(@NonNull UserChatWrapper userChatRepo) {
                    if (userChatRepo.getUserChat() != null) {
                        userChatRepo.update();
                        ChatPresenter2.this.view.onUserChatChange(ChatPresenter2.this.userChat, userChatRepo.getUserChat());
                        ChatPresenter2.this.onUserChatChange(ChatPresenter2.this.userChat, userChatRepo.getUserChat());
                        ChatPresenter2.this.userChat = userChatRepo.getUserChat();
                        ChatPresenter2.this.session = userChatRepo.getSession();
                        ChatPresenter2.this.chatState = ChatState.USER_CHAT_LOADED;
                        ChatPresenter2.this.fetchInitMessages();
                    }
                }
            });
        }
    }

    private void fetchInitMessages() {
        if ((this.chatState == ChatState.USER_CHAT_LOADED || this.chatState == ChatState.INIT_MESSAGES_NOT_LOADED) && this.chatId != null) {
            this.receiveMessagesWaitingQueue.clear();
            this.chatState = ChatState.INIT_MESSAGES_LOADING;
            ChannelApiManager.callOnce("API_TAG_FETCH_INIT_MESSAGES", ChannelApiManager.get().getMessages(this.chatId, "zzzzzzzzzzzzzzzz", 30, "DESC"), new RestSubscriber<MessagesWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter2.this.chatState = ChatState.INIT_MESSAGES_NOT_LOADED;
                    ChatPresenter2.this.view.onError();
                    ChatPresenter2.this.receiveMessagesWaitingQueue.clear();
                    L.e(error.getMessage());
                }

                @Override
                public void onSuccess(@NonNull MessagesWrapper messagesRepo) {
                    ChatPresenter2.this.chatState = ChatState.CHAT_READY;
                    messagesRepo.update();
                    ChatPresenter2.this.backwardId = messagesRepo.getNext();
                    List<Message> messages = ListUtils.union(messagesRepo.getMessages(), ChatPresenter2.this.receiveMessagesWaitingQueue);
                    ChatPresenter2.this.receiveMessagesWaitingQueue.clear();
                    ChatPresenter2.this.adapterModel.setMessages(messages);
                    ChatPresenter2.this.adapterModel.addMessageItems(ChatManager.get().getSendingItems(ChatPresenter2.this.chatId));
                    ChatPresenter2.this.adapterModel.addMessageItems(ChatManager.get().getSendingFailedItems(ChatPresenter2.this.chatId));
                    ChatPresenter2.this.updateNewMessageItem(messages);
                    if (ChatPresenter2.this.chatId != null && ChatPresenter2.this.sendingMessagesWaitingQueue.size() > 0) {
                        ArrayList<SendingMessageItem> sendingQueue = new ArrayList<SendingMessageItem>();
                        ArrayList<SendingMessageItem> failedQueue = new ArrayList<SendingMessageItem>();
                        for (SendingMessageItem item : ChatPresenter2.this.sendingMessagesWaitingQueue) {
                            item.setChatId(ChatPresenter2.this.chatId);
                            switch (item.getSendingState()) {
                                case WAITING: {
                                    sendingQueue.add(item);
                                    break;
                                }
                                case FAIL: {
                                    failedQueue.add(item);
                                }
                            }
                        }
                        ChatManager.get().send(sendingQueue);
                        ChatManager.get().updateFailedMessages(failedQueue);
                        ChatPresenter2.this.adapterModel.addMessageItems(ChatPresenter2.this.sendingMessagesWaitingQueue);
                        ChatPresenter2.this.sendingMessagesWaitingQueue.clear();
                    }
                    ChatManager.get().read(ChatPresenter2.this.chatId);
                    ChatPresenter2.this.view.scrollToBottom();
                }
            });
        }
    }

    @Override
    public void fetchBackwardMessages() {
        if (this.chatId != null && this.backwardId != null && this.chatState == ChatState.CHAT_READY && !ChannelApiManager.isRunning("API_TAG_FETCH_BACKWARD_MESSAGES")) {
            ChannelApiManager.callOnce("API_TAG_FETCH_BACKWARD_MESSAGES", ChannelApiManager.get().getMessages(this.chatId, this.backwardId, 30, "DESC"), new RestSubscriber<MessagesWrapper>(){

                @Override
                public void onNext(MessagesWrapper messagesRepo) {
                    messagesRepo.update();
                    ChatPresenter2.this.backwardId = messagesRepo.getNext();
                    ChatPresenter2.this.adapterModel.addMessages(messagesRepo.getMessages());
                    ChatPresenter2.this.updateNewMessageItem(messagesRepo.getMessages());
                }
            });
        }
    }

    private void updateNewMessageItem(@Nullable List<Message> messages) {
        if (this.session == null || this.session.getReadAt() == null) {
            return;
        }
        long lastReadAt = this.session.getReadAt();
        Message minMessage = ListUtils.takeFirstPrioirty(messages, Message.getMinComparator());
        Message maxMessage = ListUtils.takeFirstPrioirty(messages, Message.getMaxComparator());
        if (minMessage != null && minMessage.getCreatedAt() <= lastReadAt && maxMessage != null && maxMessage.getCreatedAt() > lastReadAt) {
            this.adapterModel.upsertNewMessageItem(lastReadAt);
        }
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        switch (command) {
            case APP_STARTED: {
                if (this.chatState != ChatState.WAITING_SOCKET) break;
                this.refresh();
                break;
            }
            case SOCKET_ERROR: {
                if (!this.chatState.isInitialized()) break;
                this.chatState = ChatState.WAITING_SOCKET;
                this.view.onError();
                break;
            }
            case SOCKET_DISCONNECTED: {
                if (!this.chatState.isInitialized()) break;
                this.chatState = ChatState.WAITING_SOCKET;
                if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) break;
                this.view.onError();
                break;
            }
            case READY: {
                this.view.onTryRefresh();
                this.checkSocketState();
                break;
            }
            case JOINED: {
                if (object == null || !(object instanceof String) || !CompareUtils.isSame(this.chatId, (String)object) || this.chatState != ChatState.CHAT_JOINING) break;
                this.chatState = ChatState.CHAT_JOINED;
                this.view.onTryRefresh();
                this.fetchUserChat();
            }
        }
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        switch (storeType) {
            case USER: 
            case VEIL: {
                if (entity == null || !(entity instanceof Guest)) break;
                Guest guest = GuestSelector.get();
                Guest newGuest = (Guest)entity;
                if (guest == null || !newGuest.isOwnedBy(guest.getPersonType(), guest.getPersonId())) break;
                this.view.refreshChatCount(false);
                break;
            }
            case CHANNEL: {
                if (entity == null || !(entity instanceof Channel) || updateType != UpdateType.UPDATE) break;
                this.view.bindChannel((Channel)entity);
                break;
            }
            case USER_CHAT: {
                if (entity == null || !(entity instanceof UserChat)) break;
                UserChat userChat = (UserChat)entity;
                if (this.chatId == null || !CompareUtils.isSame(this.chatId, userChat.getId())) break;
                this.view.onUserChatChange(this.userChat, userChat);
                this.onUserChatChange(this.userChat, userChat);
                this.userChat = userChat;
                ChatManager.get().read(this.chatId);
                break;
            }
            case MESSAGE: {
                if (entity == null || !(entity instanceof Message) || updateType != UpdateType.UPDATE) break;
                Message message = (Message)entity;
                if (this.chatId == null || !this.chatId.equals(message.getChatId())) break;
                if (this.chatState == ChatState.INIT_MESSAGES_LOADING) {
                    this.receiveMessagesWaitingQueue.add(message);
                    break;
                }
                if (this.chatState != ChatState.CHAT_READY) break;
                this.adapterModel.addMessage(message);
                if (CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"Veil", "User"})) break;
                this.view.onHostMessageArrive(message);
                break;
            }
            case PUSH_BOT_ITEM: {
                this.view.refreshMenu(this.isLocalChat());
                this.view.refreshChatCount(true);
            }
        }
    }

    @Override
    public void receiveTyping(Typing typing) {
        if (this.typingManager.isReady() && typing != null && typing.isOther() && typing.isSameChat(this.chatId, "UserChat")) {
            this.typingManager.refreshTypingExpiresAt(typing);
            switch (typing.getAction()) {
                case "start": {
                    this.adapterModel.upsertTyping(typing);
                    break;
                }
                case "stop": {
                    this.adapterModel.removeTyping(typing);
                }
            }
        }
    }

    @Override
    public void sendText(String text) {
        SendingMessageItem item = new SendingMessageItem(this.chatId).setText(text);
        this.adapterModel.addMessageItem(item);
        this.sendMessages(Collections.singletonList(item));
    }

    @Override
    public void sendFiles(@Nullable ArrayList<String> paths) {
        ArrayList<SendingMessageItem> items = new ArrayList<SendingMessageItem>();
        if (paths != null) {
            for (String filePath : paths) {
                SendingMessageItem item = new SendingMessageItem(this.chatId).setFilePath(filePath);
                this.adapterModel.addMessageItem(item);
                items.add(item);
            }
        }
        this.sendMessages(items);
    }

    private void sendMessages(List<SendingMessageItem> items) {
        this.view.scrollToBottom();
        if (this.chatId != null) {
            ChatManager.get().send(items);
        } else {
            this.sendingMessagesWaitingQueue.addAll(items);
            switch (this.chatState) {
                case LOCAL_WELCOME: {
                    this.createUserChat();
                }
            }
        }
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        if (CompareUtils.exists((Comparable)((Object)actionType), (Comparable[])new String[]{"userChat.solve", "userChat.close"}) && CompareUtils.isSame(actionButton.getKey(), "reopen")) {
            this.reopenChat(actionButton);
            return;
        }
        SendingMessageItem messageItem = new SendingMessageItem(this.chatId).setActionBundle(actionType, actionButton);
        this.adapterModel.addMessageItem(messageItem);
        switch (actionType) {
            case "userChat.solve": 
            case "userChat.close": {
                ChatManager.get().send(messageItem);
                break;
            }
            case "supportBot": {
                if (this.isLocalChat()) {
                    this.sendingMessagesWaitingQueue.add(messageItem);
                    this.createSupportBotUserChat(messageItem);
                    break;
                }
                ChatManager.get().send(messageItem);
                break;
            }
            case "select": {
                if (!this.isLocalChat()) break;
                ChatManager.get().send(messageItem);
                break;
            }
            default: {
                if (!this.isLocalChat()) break;
                ChatManager.get().send(messageItem);
            }
        }
    }

    @Override
    public void resend(@Nullable SendingMessageItem item) {
        if (item != null) {
            this.cancelSend(item);
            SendingMessageItem newItem = SendingMessageItem.copyContentFrom(item);
            this.adapterModel.addMessageItem(newItem);
            this.adapterModel.removeMessageItem(item);
            this.sendingMessagesWaitingQueue.remove(item);
            if (this.chatId != null) {
                ChatManager.get().send(newItem);
            } else {
                this.sendingMessagesWaitingQueue.add(newItem);
                switch (this.chatState) {
                    case LOCAL_WELCOME: {
                        this.createUserChat();
                        break;
                    }
                    case LOCAL_SUPPORTING: {
                        this.createSupportBotUserChat(newItem);
                    }
                }
            }
        }
    }

    @Override
    public void cancelSend(@Nullable SendingMessageItem item) {
        if (item != null) {
            ChatManager.get().removeSendingFailedItem(item.getPrimaryKey());
            this.adapterModel.removeMessageItem(item);
        }
    }

    @Override
    public void onSendSuccess(Message message) {
        this.adapterModel.addMessage(message);
    }

    @Override
    public void onSendFail(SendingMessageItem item) {
        this.adapterModel.addMessageItem(item);
    }

    private void createUserChat() {
        Plugin plugin = PluginSelector.getPlugin();
        if (plugin != null && plugin.getId() != null) {
            this.view.showProgress(ResUtils.getString("ch.loading_information"));
            ChannelApiManager.call(ChannelApiManager.get().createUserChat(plugin.getId()), new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter2.this.view.hideProgress();
                    for (SendingMessageItem item : ChatPresenter2.this.sendingMessagesWaitingQueue) {
                        item.setSendingState(SendingState.FAIL);
                    }
                    ChatPresenter2.this.adapterModel.addMessageItems(ChatPresenter2.this.sendingMessagesWaitingQueue);
                    L.e(error.getMessage());
                }

                @Override
                public void onSuccess(@NonNull UserChatWrapper userChatRepo) {
                    ChatPresenter2.this.view.hideProgress();
                    userChatRepo.update();
                    if (userChatRepo.getMessage() != null) {
                        ChatPresenter2.this.adapterModel.replaceInitMessage(userChatRepo.getMessage());
                    }
                    if (userChatRepo.getUserChat() != null) {
                        UserChat oldUserChat = ChatPresenter2.this.userChat;
                        ChatPresenter2.this.chatId = userChatRepo.getUserChat().getId();
                        ChatPresenter2.this.userChat = userChatRepo.getUserChat();
                        ChatPresenter2.this.session = userChatRepo.getSession();
                        ChatPresenter2.this.view.onUserChatChange(oldUserChat, userChatRepo.getUserChat());
                        ChatPresenter2.this.onUserChatChange(oldUserChat, userChatRepo.getUserChat());
                        ChatPresenter2.this.chatState = ChatState.WAITING_SOCKET;
                        ChatPresenter2.this.checkSocketState();
                    }
                }
            });
        }
    }

    private void createSupportBotUserChat(final SendingMessageItem item) {
        String supportBotId = SupportBotSelector.getSupportBotId();
        if (supportBotId != null) {
            ChannelApiManager.call(ChannelApiManager.get().createSupportBotUserChat(supportBotId), new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    for (SendingMessageItem item2 : ChatPresenter2.this.sendingMessagesWaitingQueue) {
                        item2.setSendingState(SendingState.FAIL);
                    }
                    ChatPresenter2.this.adapterModel.addMessageItems(ChatPresenter2.this.sendingMessagesWaitingQueue);
                }

                @Override
                public void onSuccess(@NonNull UserChatWrapper userChatRepo) {
                    Message message;
                    userChatRepo.update();
                    if (userChatRepo.getUserChat() != null) {
                        UserChat oldUserChat = ChatPresenter2.this.userChat;
                        RxBus.post(new ChannelModelBus(userChatRepo.getUserChat(), true));
                        RxBus.post(new ChannelModelBus(userChatRepo.getSession(), true));
                        ChatPresenter2.this.chatId = userChatRepo.getUserChat().getId();
                        ChatPresenter2.this.userChat = userChatRepo.getUserChat();
                        ChatPresenter2.this.session = userChatRepo.getSession();
                        ChatPresenter2.this.view.onUserChatChange(oldUserChat, userChatRepo.getUserChat());
                        ChatPresenter2.this.onUserChatChange(oldUserChat, userChatRepo.getUserChat());
                    }
                    if ((message = userChatRepo.getMessage()) != null) {
                        ChatPresenter2.this.adapterModel.replaceInitMessage(message);
                        item.updateMessageOnActionInput(message);
                    }
                    ChatPresenter2.this.chatState = ChatState.WAITING_SOCKET;
                    ChatPresenter2.this.checkSocketState();
                }
            });
        }
    }

    @Override
    public void createPushBotUserChat() {
        if (this.pushBotId != null) {
            ChannelApiManager.call(ChannelApiManager.get().createPushBotUserChat(this.pushBotId), new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter2.this.view.setPushBotSaveButtonVisibility(true);
                    for (SendingMessageItem item : ChatPresenter2.this.sendingMessagesWaitingQueue) {
                        item.setSendingState(SendingState.FAIL);
                    }
                    ChatPresenter2.this.adapterModel.addMessageItems(ChatPresenter2.this.sendingMessagesWaitingQueue);
                    L.e(error.getMessage());
                }

                @Override
                public void onSuccess(@NonNull UserChatWrapper userChatRepo) {
                    PushBotItem pushBotItem;
                    userChatRepo.update();
                    if (ChatPresenter2.this.pushBotId != null && (pushBotItem = PushBotSelector.get(ChatPresenter2.this.pushBotId)) != null) {
                        pushBotItem.remove();
                        Store.getInstance(PushBotItemStore.class).add(pushBotItem);
                    }
                    if (userChatRepo.getMessage() != null) {
                        ChatPresenter2.this.adapterModel.replaceInitMessage(userChatRepo.getMessage());
                    }
                    if (userChatRepo.getUserChat() != null) {
                        UserChat oldUserChat = ChatPresenter2.this.userChat;
                        ChatPresenter2.this.chatId = userChatRepo.getUserChat().getId();
                        ChatPresenter2.this.userChat = userChatRepo.getUserChat();
                        ChatPresenter2.this.session = userChatRepo.getSession();
                        ChatPresenter2.this.view.onUserChatChange(oldUserChat, userChatRepo.getUserChat());
                        ChatPresenter2.this.onUserChatChange(oldUserChat, userChatRepo.getUserChat());
                        ChatPresenter2.this.chatState = ChatState.WAITING_SOCKET;
                        ChatPresenter2.this.checkSocketState();
                        ChatPresenter2.this.keepPushBot();
                    }
                }
            });
        }
    }

    @Override
    public void fetchCountries(final ProfileBotMessageItem item, final String key, final MobileNumber mobileNumber) {
        if (CountrySelector.isEmpty()) {
            this.view.showProgress(ResUtils.getString("ch.loading_information"));
            ChannelApiManager.call(ChannelApiManager.get().getCountries(), new RestSubscriber<List<Country>>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter2.this.view.hideProgress();
                }

                @Override
                public void onSuccess(@NonNull List<Country> countries) {
                    Store.getInstance(CountryStore.class).set(countries);
                    ChatPresenter2.this.view.hideProgress();
                    ChatPresenter2.this.view.onCountriesFetch(item, key, mobileNumber);
                }
            });
        } else {
            this.view.onCountriesFetch(item, key, mobileNumber);
        }
    }

    @Override
    public void selectCountry(ProfileBotMessageItem item, String key, MobileNumber mobileNumber, String countryCode) {
        mobileNumber.setCountryCode(Integer.valueOf(countryCode));
        item.setInputState(key, mobileNumber, false, null);
        this.adapterModel.addMessageItem(item);
    }

    @Override
    public void updateProfile(final ProfileBotMessageItem item, final String key, Object value) {
        item.setInputState(key, item.getInputState(), true, null);
        this.adapterModel.addMessageItem(item);
        RequestBody requestBody = RequestUtils.form().set(key, value).create();
        ChannelApiManager.call(ChannelApiManager.get().updateProfileBot(item.getMessage().getId(), requestBody), new RestSubscriber<MessageWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                item.setInputState(key, item.getInputState(), false, ResUtils.getString("ch.profile_form.error"));
                ChatPresenter2.this.adapterModel.addMessageItem(item);
                ChatPresenter2.this.view.tryScrollToBottom();
            }

            @Override
            public void onSuccess(@NonNull MessageWrapper messageRepo) {
                messageRepo.update();
                item.setMessage(messageRepo.getMessage());
                item.resetInputState();
                ChatPresenter2.this.adapterModel.addMessageItem(item);
                ChatPresenter2.this.view.tryScrollToBottom();
            }
        });
    }

    @Override
    public void translateMessage(final @NonNull Message message, String targetLanguage) {
        if (this.chatId != null) {
            final String uniqueId = TranslationInfo.createId(message.getId(), targetLanguage);
            TranslationInfo translationInfo = TranslationSelector.get(uniqueId);
            if (translationInfo == null) {
                Store.getInstance(TranslationStore.class).add(TranslationInfo.createProgressStateInfo(uniqueId));
                this.adapterModel.addMessage(message);
                ChannelApiManager.call(ChannelApiManager.get().getTranslatedMessage(message.getId(), targetLanguage), new RestSubscriber<TranslationRepo>(){

                    @Override
                    public void onError(RetrofitException error) {
                        Store.getInstance(TranslationStore.class).add(TranslationInfo.createOriginStateInfo(uniqueId));
                        ChatPresenter2.this.adapterModel.addMessage(message);
                    }

                    @Override
                    public void onSuccess(@NonNull TranslationRepo repo) {
                        if (repo.getTranslatedMessage() != null) {
                            TranslationInfo info = new TranslationInfo(uniqueId, repo.getTranslatedMessage(), TranslationState.TRANSLATED);
                            Store.getInstance(TranslationStore.class).add(info);
                        } else {
                            Store.getInstance(TranslationStore.class).add(TranslationInfo.createOriginStateInfo(uniqueId));
                        }
                        ChatPresenter2.this.adapterModel.addMessage(message);
                    }
                });
            } else {
                translationInfo.setState(TranslationState.ORIGIN.equals((Object)translationInfo.getState()) ? TranslationState.TRANSLATED : TranslationState.ORIGIN);
                Store.getInstance(TranslationStore.class).add(translationInfo);
                this.adapterModel.addMessage(message);
            }
        }
    }

    @Override
    public boolean hasBackwardMessages() {
        return this.backwardId != null;
    }

    @Override
    public boolean isLocalChat() {
        return this.chatId == null;
    }

    private void onUserChatChange(@Nullable UserChat oldUserChat, @NonNull UserChat newUserChat) {
        if (!this.typingManager.isReady()) {
            this.typingManager.setChatId(newUserChat.getId());
        }
        if (oldUserChat != null && CompareUtils.exists((Comparable)((Object)oldUserChat.getState()), (Comparable[])new String[]{"ready", "supporting"}) && "open".equals(newUserChat.getState())) {
            this.requestProfileBot();
        }
    }

    private void requestProfileBot() {
        Plugin plugin = PluginSelector.getPlugin();
        if (plugin != null && !TextUtils.isEmpty((CharSequence)this.chatId)) {
            ChannelApiManager.call(ChannelApiManager.get().requestProfileBot(this.chatId, plugin.getId()), new RestSubscriber());
        }
    }

    private void reopenChat(@NonNull ActionButton actionButton) {
        if (this.userChat != null) {
            Message message = actionButton.getMessage();
            message.clearAction();
            this.adapterModel.addMessage(message);
            this.userChat.setState("continue_chat");
            this.view.onUserChatChange(this.userChat, this.userChat);
        }
    }

    private void keepPushBot() {
        if (this.chatId != null) {
            ChannelApiManager.call(ChannelApiManager.get().keepPushBot(this.chatId), new RestSubscriber<MessageWrapper>(){

                @Override
                public void onSuccess(@NonNull MessageWrapper messageWrapper) {
                    ChatPresenter2.this.adapterModel.addMessage(messageWrapper.getMessage());
                    ChatPresenter2.this.view.scrollToBottom();
                }
            });
        }
    }

    private void cancelApis() {
        ChannelApiManager.cancel("API_TAG_FETCH_USER_CHAT");
        ChannelApiManager.cancel("API_TAG_FETCH_INIT_MESSAGES");
        ChannelApiManager.cancel("API_TAG_FETCH_BACKWARD_MESSAGES");
    }
}

