/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorTake<T>
implements Observable.Operator<T, T> {
    final int limit;

    public OperatorTake(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit >= 0 required but it was " + limit);
        }
        this.limit = limit;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber parent = new Subscriber<T>(){
            int count;
            boolean completed;

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    this.completed = true;
                    child.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.completed) {
                    this.completed = true;
                    try {
                        child.onError(e);
                    }
                    finally {
                        this.unsubscribe();
                    }
                }
            }

            @Override
            public void onNext(T i) {
                if (!this.isUnsubscribed() && this.count++ < OperatorTake.this.limit) {
                    boolean stop = this.count == OperatorTake.this.limit;
                    child.onNext(i);
                    if (stop && !this.completed) {
                        this.completed = true;
                        try {
                            child.onCompleted();
                        }
                        finally {
                            this.unsubscribe();
                        }
                    }
                }
            }

            @Override
            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){
                    final AtomicLong requested = new AtomicLong(0L);

                    public void request(long n) {
                        if (n > 0L && !completed) {
                            long r;
                            long c;
                            while ((c = Math.min(n, (long)OperatorTake.this.limit - (r = this.requested.get()))) != 0L) {
                                if (!this.requested.compareAndSet(r, r + c)) continue;
                                producer.request(c);
                                break;
                            }
                        }
                    }
                });
            }
        };
        if (this.limit == 0) {
            child.onCompleted();
            parent.unsubscribe();
        }
        child.add(parent);
        return parent;
    }
}

