/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelLauncherView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.event.ChannelViewBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.InAppPushSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.PushBotSelector;
import com.zoyi.channel.plugin.android.selector.UiStateSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.popup.InAppPushView;
import com.zoyi.channel.plugin.android.view.popup.PushBotPopupView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

class ChannelView
extends FrameLayout
implements OnPushBotClickListener {
    private Context context;
    private ChannelLauncherView channelLauncherView;
    private PushBotPopupView pushBotPopupView;
    private InAppPushView inAppPushView;
    @Nullable
    private Subscription subscription;

    public ChannelView(Context context) {
        super(context);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this, true);
        this.channelLauncherView = (ChannelLauncherView)view.findViewById(R.id.ch_view_launcher);
        this.pushBotPopupView = (PushBotPopupView)view.findViewById(R.id.ch_view_push_bot_popup);
        this.inAppPushView = (InAppPushView)view.findViewById(R.id.ch_view_in_app_push);
        this.pushBotPopupView.setPushBotClickListener(this);
        this.subscription = RxBus.observable().subscribe(this.getChannelViewEventSubscriber());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (ChannelIO.isBooted()) {
            this.boot();
        }
    }

    private void boot() {
        this.setVisibility(0);
        this.initLauncher();
        if (UiStateSelector.shouldShowLauncher()) {
            this.showLauncherView();
            this.trackPageViewEvent();
        } else {
            this.hideLauncherView();
        }
        if (UiStateSelector.shouldShowInAppPush()) {
            this.showInAppPush();
        } else {
            this.hideInAppPush();
        }
    }

    private void initLauncher() {
        this.channelLauncherView.setLauncherLayout(ChannelIOSelector.getLauncherConfig());
        this.channelLauncherView.setLauncherBackgroundColor(ColorSelector.getBackgroundColor(), ColorSelector.getGradientColor());
        this.channelLauncherView.setBadgeCount(CounterSelector.getTotalCounter());
        this.channelLauncherView.setLauncherIcon(UIUtils.getLauncherIcon(CounterSelector.getTotalCounter(), ColorSelector.getTextColor(), PushBotSelector.hasVisiblePushBot()));
    }

    private void showLauncherView() {
        this.channelLauncherView.show();
    }

    private void hideLauncherView() {
        this.channelLauncherView.hide();
    }

    private void showInAppPush() {
        this.pushBotPopupView.hide();
        this.inAppPushView.show(InAppPushSelector.getInAppPushItem());
    }

    private void hideInAppPush() {
        this.inAppPushView.hide();
    }

    private void showPushBot(PushBotItem item) {
        this.pushBotPopupView.show(item);
    }

    private void hidePushBot() {
        this.pushBotPopupView.hide();
    }

    private void release() {
        this.setVisibility(8);
        this.inAppPushView.hide();
        this.pushBotPopupView.hide();
        this.channelLauncherView.hide();
    }

    private Action1<Object> getChannelViewEventSubscriber() {
        return new Action1<Object>(){

            public void call(Object o) {
                if (o instanceof CommandBus) {
                    CommandBus commandBus = (CommandBus)o;
                    switch (commandBus.getCommand()) {
                        case BOOT: {
                            ChannelView.this.boot();
                            break;
                        }
                        case SHUTDOWN: {
                            ChannelView.this.release();
                        }
                    }
                }
                if (o instanceof ChannelViewBus) {
                    ChannelViewBus channelViewBus = (ChannelViewBus)o;
                    switch (channelViewBus.getChannelViewEvent()) {
                        case UPDATE_LAUNCHER_VISIBILITY: {
                            if (UiStateSelector.shouldShowLauncher()) {
                                if (!ChannelView.this.channelLauncherView.isVisible() && CompareUtils.isSameActivity(ChannelView.this.context, (Context)ChannelIO.getTopActivity())) {
                                    ChannelView.this.trackPageViewEvent();
                                }
                                ChannelView.this.showLauncherView();
                                break;
                            }
                            ChannelView.this.hideLauncherView();
                            break;
                        }
                        case SHOW_PUSH_BOT: {
                            if (!CompareUtils.isSameActivity(ChannelView.this.context, (Context)ChannelIO.getTopActivity()) || channelViewBus.getData() == null || !(channelViewBus.getData() instanceof PushBotItem)) break;
                            ChannelView.this.showPushBot((PushBotItem)channelViewBus.getData());
                            ChannelView.this.hideInAppPush();
                            break;
                        }
                        case SHOW_IN_APP_PUSH: {
                            if (!UiStateSelector.shouldShowInAppPush()) break;
                            ChannelView.this.showInAppPush();
                            ChannelView.this.hidePushBot();
                            break;
                        }
                        case HIDE_IN_APP_PUSH: {
                            ChannelView.this.hideInAppPush();
                        }
                    }
                }
                if (o instanceof StoreBus) {
                    StoreBus storeBus = (StoreBus)o;
                    if (CompareUtils.exists((Comparable)((Object)storeBus.getStoreType()), (Comparable[])new StoreType[]{StoreType.USER, StoreType.VEIL, StoreType.PUSH_BOT_ITEM})) {
                        ChannelView.this.channelLauncherView.setBadgeCount(CounterSelector.getTotalCounter());
                        ChannelView.this.channelLauncherView.setLauncherIcon(UIUtils.getLauncherIcon(CounterSelector.getTotalCounter(), ColorSelector.getTextColor(), PushBotSelector.hasVisiblePushBot()));
                    }
                    if (storeBus.getStoreType() == StoreType.PLUGIN) {
                        ChannelView.this.channelLauncherView.setLauncherBackgroundColor(ColorSelector.getBackgroundColor(), ColorSelector.getGradientColor());
                        ChannelView.this.channelLauncherView.setLauncherIcon(UIUtils.getLauncherIcon(CounterSelector.getTotalCounter(), ColorSelector.getTextColor(), PushBotSelector.hasVisiblePushBot()));
                    }
                }
            }
        };
    }

    private void trackPageViewEvent() {
        String pluginId = PluginSelector.getPluginId();
        if (pluginId != null && ChannelIOSelector.isEnabledTrackDefaultEvent()) {
            ChannelIOManager.trackPageView(this.context, pluginId);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    @Override
    public void onPushBotClick(@NonNull String pushBotId) {
        this.startPushBotChat(pushBotId);
    }

    @Override
    public void onPushBotContentsClick(@NonNull String pushBotId, @Nullable String redirectUrl) {
        if (redirectUrl != null) {
            Executor.executeRedirectUrlAction(this.context, redirectUrl);
        } else {
            this.startPushBotChat(pushBotId);
        }
    }

    private void startPushBotChat(@NonNull String pushBotId) {
        IntentUtils.setNextActivity(this.context, UserChatListActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).putExtra("pushBotId", pushBotId).startActivity();
    }
}

