package com.zoyi.channel.plugin.android.model.source.photopicker;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by mika on 8/31/16.
 */

public class PhotoItem implements Parcelable {
  private long id;
  private String name;
  private String path;
  private int index;

  public PhotoItem(long id, String name, String path, int index) {
    this.id = id;
    this.name = name;
    this.path = path;
    this.index = index;
  }

  @Override
  public boolean equals(Object o) {
    boolean ret = false;

    if (o != null && o instanceof PhotoItem) {
      PhotoItem next = (PhotoItem) o;

      ret = this.id == next.id;
    }
    return ret;
  }

  public long getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public String getPath() {
    return path;
  }

  public int getIndex() {
    return index;
  }

  protected PhotoItem(Parcel in) {
    id = in.readLong();
    name = in.readString();
    path = in.readString();
    index = in.readInt();
  }

  public static final Creator<PhotoItem> CREATOR = new Creator<PhotoItem>() {
    @Override
    public PhotoItem createFromParcel(Parcel in) {
      return new PhotoItem(in);
    }

    @Override
    public PhotoItem[] newArray(int size) {
      return new PhotoItem[size];
    }
  };

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    dest.writeLong(id);
    dest.writeString(name);
    dest.writeString(path);
    dest.writeInt(index);
  }
}
