package com.zoyi.channel.plugin.android.activity.userchat_list.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.MessageSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChatItem implements ChatListItem {
  @NonNull
  private UserChat userChat;

  public UserChatItem(@NonNull UserChat userChat) {
    this.userChat = userChat;
  }

  @NonNull
  public UserChat getUserChat() {
    return userChat;
  }

  public void setUserChat(@NonNull UserChat userChat) {
    this.userChat = userChat;
  }

  @NonNull
  @Override
  public String getId() {
    return userChat.getId();
  }

  // UI render methods

  @Nullable
  public ProfileEntity getProfile() {
    return ProfileSelector.getHostProfile(userChat.getHostType(), userChat.getHostId());
  }

  @Nullable
  public Message getLastMessage() {
    return MessageSelector.get(userChat.getLastMessageId());
  }

  public String getAlert() {
    return CounterSelector.getChatCounter(userChat.getId());
  }

  @NonNull
  public String getUpdatedDate() {
    if (userChat.isStateClosed() && userChat.getClosedAt() != null) {
      return TimeUtils.get(userChat.getClosedAt());
    }
    if (userChat.getUpdatedAt() != null) {
      return TimeUtils.get(userChat.getUpdatedAt());
    }

    return "";
  }

  @Override
  public ChatListItemType getItemType() {
    return ChatListItemType.USER_CHAT;
  }

  @Nullable
  public String getHostType() {
    return userChat.getHostType();
  }

  @Nullable
  public String getHostId() {
    return userChat.getHostId();
  }

  // Sortable item methods

  @NonNull
  @Override
  public Long getPrimaryKey() {
    if (userChat.getUpdatedAt() != null) {
      return userChat.getUpdatedAt();
    }
    return 0L;
  }

  @NonNull
  @Override
  public String getSecondaryKey() {
    return userChat.getId();
  }
}
