/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorSubscribeOn<T>
implements Observable.OnSubscribe<T> {
    final Scheduler scheduler;
    final Observable<T> source;
    final boolean requestOn;

    public OperatorSubscribeOn(Observable<T> source, Scheduler scheduler, boolean requestOn) {
        this.scheduler = scheduler;
        this.source = source;
        this.requestOn = requestOn;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        Scheduler.Worker inner = this.scheduler.createWorker();
        SubscribeOnSubscriber<? super T> parent = new SubscribeOnSubscriber<T>(subscriber, this.requestOn, inner, this.source);
        subscriber.add(parent);
        subscriber.add(inner);
        inner.schedule(parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SubscribeOnSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super T> actual;
        final boolean requestOn;
        final Scheduler.Worker worker;
        Observable<T> source;
        Thread t;

        SubscribeOnSubscriber(Subscriber<? super T> actual, boolean requestOn, Scheduler.Worker worker, Observable<T> source) {
            this.actual = actual;
            this.requestOn = requestOn;
            this.worker = worker;
            this.source = source;
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            try {
                this.actual.onError(e);
            }
            finally {
                this.worker.unsubscribe();
            }
        }

        @Override
        public void onCompleted() {
            try {
                this.actual.onCompleted();
            }
            finally {
                this.worker.unsubscribe();
            }
        }

        @Override
        public void call() {
            Observable<T> src = this.source;
            this.source = null;
            this.t = Thread.currentThread();
            src.unsafeSubscribe(this);
        }

        @Override
        public void setProducer(final Producer p) {
            this.actual.setProducer(new Producer(){

                public void request(final long n) {
                    if (SubscribeOnSubscriber.this.t == Thread.currentThread() || !SubscribeOnSubscriber.this.requestOn) {
                        p.request(n);
                    } else {
                        SubscribeOnSubscriber.this.worker.schedule(new Action0(){

                            public void call() {
                                p.request(n);
                            }
                        });
                    }
                }
            });
        }
    }
}

