/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.util.DeviceUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.okhttp3.RequestBody;
import java.util.HashMap;
import java.util.Map;

public class Event {
    public static final String PROPERTY_URL = "url";
    private String name;
    private Map<String, Object> property;
    private Map<String, Object> sysProperty;

    public Event(@NonNull String name, @Nullable Map<String, Object> property) {
        this.name = name;
        this.property = property;
        this.sysProperty = new HashMap<String, Object>();
        this.initSysProperty(this.sysProperty);
    }

    public RequestBody getRequestBody() {
        return RequestUtils.form().set("name", this.name).set("property", this.property).set("sysProperty", this.sysProperty).create();
    }

    private void initSysProperty(Map<String, Object> sysProperty) {
        sysProperty.put("pluginVersion", "5.1.2");
        sysProperty.put("os", DeviceUtils.getOs());
        sysProperty.put("device", Build.MODEL);
        Context context = ChannelIO.getAppContext();
        if (context != null) {
            sysProperty.put("screenWidth", Display.getWidth(context));
            sysProperty.put("screenHeight", Display.getHeight(context));
        }
    }

    @Nullable
    public String getUrlProperty() {
        Object value = this.property.get(PROPERTY_URL);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }
}

