package com.zoyi.channel.plugin.android.activity.userchat_list.holder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.UserChatItem;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChatHolder extends RecyclerView.ViewHolder implements View.OnClickListener, View.OnLongClickListener {

  public static UserChatHolder newInstance(ViewGroup parent, @Nullable OnUserChatClickListener listener) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());
    View itemView = inflater.inflate(R.layout.ch_plugin_item_user_chat, parent, false);
    return new UserChatHolder(itemView, listener);
  }

  private Context context;

  private AvatarLayout avatar;
  private CHTextView textName, textMessage, textTime, textBadge;
  @NonNull
  private ChatListItem chatListItem;

  @Nullable
  private OnUserChatClickListener listener;

  public UserChatHolder(View itemView, @Nullable OnUserChatClickListener listener) {
    super(itemView);

    this.context = itemView.getContext();
    this.listener = listener;

    avatar = (AvatarLayout) itemView.findViewById(R.id.avatar_single);
    avatar.setTextSize(16);

    textName = itemView.findViewById(R.id.text_name);
    textMessage = itemView.findViewById(R.id.text_message);
    textTime = itemView.findViewById(R.id.text_time);
    textBadge = itemView.findViewById(R.id.text_badge);

    itemView.setOnClickListener(this);
    itemView.setOnLongClickListener(this);
  }

  @Initializer
  public void setChatListItem(@NonNull ChatListItem item) {
    this.chatListItem = item;

    ProfileEntity profileEntity = item.getProfile();
    String alert = item.getAlert();

    if (profileEntity != null) {
      textName.setText(profileEntity.getName());
    }
    avatar.set(profileEntity);
    textTime.setText(item.getUpdatedDate());

    Views.setVisibility(textBadge, !TextUtils.isEmpty(alert), View.INVISIBLE);
    textBadge.setText(alert);

    switch (item.getItemType()) {
      case USER_CHAT:
        if (item instanceof UserChatItem) {
          UserChatItem userChatItem = (UserChatItem) item;
          setTextMessage(userChatItem.getUserChat(), userChatItem.getLastMessage());
        }
        break;

      case PUSH_BOT_CHAT:
        if (item instanceof PushBotChatItem) {
          textMessage.setText(((PushBotChatItem) item).getMessageText());
        }
        break;
    }
  }

  private void setTextMessage(@Nullable UserChat userChat, @Nullable Message message) {
    if (userChat != null && userChat.getReview() != null) {
      textMessage.setTextByKey("ch.review.complete.preview", R.color.ch_light);
    } else {
      if (message != null) {
        if (message.getMessage() != null) {
          if (userChat != null && userChat.isStateClosed()) {
            textMessage.setText(message.getFormattedStringMessage(), R.color.ch_light);
          } else {
            textMessage.setText(message.getFormattedStringMessage(), R.color.ch_dark);
          }
        } else if (message.getFile() != null) {
          if (message.getFile().isImage()) {
            textMessage.setTextByKey("ch.notification.upload_image.description", R.color.ch_dark);
          } else {
            textMessage.setTextByKey("ch.notification.upload_file.description", R.color.ch_dark);
          }
        } else {
          textMessage.setText("");
        }
      } else {
        textMessage.setText("");
      }
    }
  }

  @Override
  public void onClick(View view) {
    if (listener != null) {
      listener.onUserChatClick(chatListItem);
    }
  }

  @Override
  public boolean onLongClick(View v) {
    if (listener != null) {
      listener.onUserChatLongClick(chatListItem);
    }
    return true;
  }
}
