package com.zoyi.channel.plugin.android.activity.userchat_list.contract;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.base.BasePresenter;
import com.zoyi.channel.plugin.android.base.BaseView;

public interface UserChatListContract {

  interface View extends BaseView<Presenter> {

    void userChatsFetched(UserChatsWrapper userChatsWrapper, boolean init);
    void setErrorView(boolean show);
    void completeRemoveChat();
    void successFetchPreloadData(@Nullable ChatListItem chatListItem, Transition transition);
  }

  interface Presenter extends BasePresenter<View> {

    void fetchPreloadData(@Nullable ChatListItem chatListItem, Transition transition);
    void setAdapterView(UserChatAdapterContract.View adapterView);
    void setAdapterModel(UserChatAdapterContract.Model adapterModel);
    void refresh();
    void receiveCommand(Command command, @Nullable Object object);
    void receiveData(Entity entity, boolean upsert);
    void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity);
    void removeUserChat(String chatId);
    void removePushBotChat(String pushBotId);
    void redrawList();

    @Nullable ChatListItem getUserChatItem(@NonNull String id);
  }
}
