/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ContentMessageHolder;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;

public class SendingMessageHolder
extends ContentMessageHolder {
    private View rootMessageContentSending;
    private ImageView imageSendingMessage;
    private ImageView imageSendingMessageFailUpload;
    private MaskableFrameLayout frameSendingMessageImage;
    private CircularProgressView progressSendingMessage;
    @Nullable
    private SendingMessageItem sendingMessageItem;

    public static SendingMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        return new SendingMessageHolder(SendingMessageHolder.getItemView(parent, messageType), messageType, onMessageContentClickListener);
    }

    private SendingMessageHolder(View itemView, MessageType messageType, final @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        super(itemView, messageType, null);
        this.context = itemView.getContext();
        this.rootMessageContentSending = itemView.findViewById(R.id.ch_root_message_content_sending);
        this.frameSendingMessageImage = (MaskableFrameLayout)itemView.findViewById(R.id.ch_frame_sending_message_image);
        this.imageSendingMessage = (ImageView)itemView.findViewById(R.id.ch_image_sending_message);
        this.imageSendingMessageFailUpload = (ImageView)itemView.findViewById(R.id.ch_image_sending_message_upload_failed);
        this.progressSendingMessage = (CircularProgressView)itemView.findViewById(R.id.ch_progress_sending_message);
        this.setResendMessageButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onMessageContentClickListener != null && SendingMessageHolder.this.sendingMessageItem != null) {
                    onMessageContentClickListener.onResendButtonClick(SendingMessageHolder.this.sendingMessageItem);
                }
            }
        });
    }

    public void bind(SendingMessageItem item, boolean isConnectedMessage) {
        super.bind(null, item.getType(), true);
        super.setGuestMessageInfo(item, isConnectedMessage);
        this.sendingMessageItem = item;
        this.setResendMessageButtonVisibility(item.isSending());
        if (item.isMediaFile()) {
            this.setSendingImageMessage(item.getMediaFilePath(), item.isSending());
        } else {
            this.setSendingTextMessage(item.getMessage(), isConnectedMessage);
        }
    }

    private void setSendingImageMessage(@Nullable String imagePath, boolean isSending) {
        if (imagePath != null) {
            this.rootMessageContentSending.setVisibility(0);
            Point previewImageSize = Utils.resizeImage(this.context, Utils.getLocalImageSize(imagePath), false);
            Resizer.size((View)this.frameSendingMessageImage, previewImageSize.x, previewImageSize.y);
            Glide.with((Context)this.itemView.getContext()).load(imagePath).asBitmap().override(previewImageSize.x, previewImageSize.y).dontAnimate().centerCrop().into(this.imageSendingMessage);
            Views.setVisibility(this.progressSendingMessage, isSending);
            Views.setVisibility((View)this.imageSendingMessageFailUpload, !isSending);
        }
    }

    private void setSendingTextMessage(@Nullable String text, boolean isConnected) {
        SpannableStringBuilder sendingText = ParseUtils.parseMessage(text);
        if (MessageUtils.hasOnlyEmoji(sendingText)) {
            this.setGiantEmoji((CharSequence)sendingText);
        } else {
            this.setGuestMessageText((CharSequence)sendingText, isConnected);
        }
    }
}

