/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public abstract class BaseMessageHolder
extends RecyclerView.ViewHolder {
    @Nullable
    private CHTextView textGuestMessageTime;
    @Nullable
    private View buttonSendingMessageResend;
    @Nullable
    private LinearLayout layoutHostMessageProfile;
    @Nullable
    private AvatarLayout avatarHostMessage;
    @Nullable
    private CHTextView textHostMessageHostName;
    @Nullable
    private CHTextView textHostMessageTime;
    @Nullable
    private LinearLayout layoutHostMessageExtraContent;
    private LinearLayout layoutMessageContent;
    protected Context context;

    protected BaseMessageHolder(View itemView, MessageType messageType) {
        super(itemView);
        this.context = itemView.getContext();
        switch (messageType) {
            case HOST: 
            case WELCOME: 
            case SUPPORT_BOT: {
                this.layoutHostMessageProfile = (LinearLayout)itemView.findViewById(R.id.ch_layout_host_message_profile);
                this.avatarHostMessage = (AvatarLayout)itemView.findViewById(R.id.ch_avater_host_message);
                this.textHostMessageTime = (CHTextView)itemView.findViewById(R.id.ch_text_host_message_time);
                this.textHostMessageHostName = (CHTextView)itemView.findViewById(R.id.ch_text_host_message_name);
                this.layoutHostMessageExtraContent = (LinearLayout)itemView.findViewById(R.id.ch_message_content_extra);
                break;
            }
            default: {
                this.textGuestMessageTime = (CHTextView)itemView.findViewById(R.id.ch_text_guest_message_time);
                this.buttonSendingMessageResend = itemView.findViewById(R.id.ch_button_guest_message_resend);
            }
        }
        this.layoutMessageContent = (LinearLayout)itemView.findViewById(R.id.ch_layout_message_content);
    }

    protected void bind(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
        this.setMessageInfo(message, messageType, isConnectedMessage);
    }

    private void setMessageInfo(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
        switch (messageType) {
            case HOST: 
            case WELCOME: 
            case SUPPORT_BOT: {
                this.resetHostMessage();
                this.setHostMessageInfo(message, isConnectedMessage);
                break;
            }
            default: {
                this.resetGuestMessage();
                this.setGuestMessageInfo(message, isConnectedMessage);
            }
        }
        this.resetViews();
        this.resetMessageContents();
    }

    private void resetGuestMessage() {
        if (this.buttonSendingMessageResend != null) {
            this.buttonSendingMessageResend.setVisibility(8);
        }
    }

    private void resetHostMessage() {
        if (this.layoutHostMessageExtraContent != null) {
            for (int i = 0; i < this.layoutHostMessageExtraContent.getChildCount(); ++i) {
                this.layoutHostMessageExtraContent.getChildAt(i).setVisibility(8);
            }
        }
    }

    private void resetMessageContents() {
        for (int i = 0; i < this.layoutMessageContent.getChildCount(); ++i) {
            this.layoutMessageContent.getChildAt(i).setVisibility(8);
        }
    }

    protected abstract void resetViews();

    private void setGuestMessageInfo(@Nullable Message message, boolean isConnectedMessage) {
        if (this.textGuestMessageTime != null && message != null) {
            Views.setVisibility((View)this.textGuestMessageTime, !isConnectedMessage);
            this.textGuestMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));
        }
        this.layoutMessageContent.setGravity(0x800005);
    }

    protected void setGuestMessageInfo(@Nullable SendingMessageItem messageItem, boolean isConnectedMessage) {
        if (this.textGuestMessageTime != null && messageItem != null) {
            Views.setVisibility((View)this.textGuestMessageTime, !isConnectedMessage);
            this.textGuestMessageTime.setText(TimeUtils.getTime(messageItem.getCreatedAt()));
        }
        this.layoutMessageContent.setGravity(0x800005);
    }

    private void setHostMessageInfo(@Nullable Message message, boolean isConnectedMessage) {
        if (this.layoutHostMessageProfile != null && this.avatarHostMessage != null && this.textHostMessageTime != null && this.textHostMessageHostName != null && message != null) {
            this.textHostMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));
            Person profile = ProfileSelector.getPerson(message.getPersonType(), message.getPersonId());
            Views.setVisibility((View)this.layoutHostMessageProfile, !isConnectedMessage);
            this.avatarHostMessage.set(profile);
            String name = profile != null ? profile.getName() : ResUtils.getString(this.context, "ch.unknown");
            this.textHostMessageHostName.setText(name);
        }
    }

    protected void setResendMessageButtonClickListener(View.OnClickListener onClickListener) {
        if (this.buttonSendingMessageResend != null) {
            this.buttonSendingMessageResend.setOnClickListener(onClickListener);
        }
    }

    protected void setResendMessageButtonVisibility(boolean isSending) {
        if (this.buttonSendingMessageResend != null) {
            Views.setVisibility(this.buttonSendingMessageResend, !isSending);
        }
    }

    protected static View getItemView(ViewGroup parent, MessageType messageType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (messageType) {
            case HOST: 
            case WELCOME: 
            case SUPPORT_BOT: {
                return inflater.inflate(R.layout.ch_plugin_item_message_host, parent, false);
            }
        }
        return inflater.inflate(R.layout.ch_plugin_item_message_guest, parent, false);
    }
}

