/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.DateItem;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ChatMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.DateDividerHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.LogMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.NewMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ProfileBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SendingMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SupportBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TypingHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.WelcomeMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.SupportBotEntry;
import com.zoyi.channel.plugin.android.store.ImageFileStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ListUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChatAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ChatAdapterContract.Model,
ChatAdapterContract.View {
    private SortedList<MessageItem> items;
    @Nullable
    private OnProfileUpdateListener onProfileUpdateListener;
    @Nullable
    private OnMessageContentClickListener onMessageContentClickListener;
    @Nullable
    private WelcomeMessageItem welcomeMessageItem = null;
    @Nullable
    private SupportBotMessageItem supportBotMessageItem = null;
    private boolean isNewChat;
    private boolean hasChatEditTextFocus = false;

    public ChatAdapter(boolean isNewChat) {
        this.isNewChat = isNewChat;
        this.items = new SortedList(MessageItem.class, new SortedListCallback(this, false));
        this.items.add((Object)new TypingItem());
    }

    @Override
    public void setOnProfileUpdateListener(@Nullable OnProfileUpdateListener onProfileUpdateListener) {
        this.onProfileUpdateListener = onProfileUpdateListener;
    }

    @Override
    public void setOnMessageContentClickListener(@Nullable OnMessageContentClickListener onMessageContentClickListener) {
        this.onMessageContentClickListener = onMessageContentClickListener;
    }

    @Override
    public void addMessage(Message message, @Nullable String chatId) {
        this.addMessages(Collections.singletonList(message), chatId);
    }

    @Override
    public void addMessages(@Nullable List<Message> messages, @Nullable String chatId) {
        if (!ListUtils.hasItems(messages) || TextUtils.isEmpty((CharSequence)chatId)) {
            return;
        }
        this.items.beginBatchedUpdates();
        for (Message message : messages) {
            SendingMessageItem item;
            if (message == null || !CompareUtils.isSame(chatId, message.getChatId())) continue;
            if (this.isNewChat && message.getBotOption() != null && message.getBotOption().isWelcome() && this.welcomeMessageItem != null) {
                this.items.remove((Object)this.welcomeMessageItem);
                this.items.add((Object)new DateItem(message.getCreatedAt()));
                this.items.add((Object)new ChatMessageItem(message));
                this.welcomeMessageItem = null;
                continue;
            }
            if (message.getLog() != null) {
                this.items.add((Object)new LogMessageItem(message));
                continue;
            }
            if (message.getFile() != null && message.getFile().isImageFile()) {
                Store.getInstance(ImageFileStore.class).add(message.getFile());
            }
            this.items.add((Object)new ChatMessageItem(message));
            this.items.add((Object)new DateItem(message.getCreatedAt()));
            if (message.getProfileBot() != null) {
                this.items.add((Object)new ProfileBotMessageItem(message));
                continue;
            }
            if (!CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"User", "Veil"}) || (item = SendingMessageItem.create(message.getRequestId())) == null) continue;
            this.items.remove((Object)item);
        }
        this.items.endBatchedUpdates();
    }

    @Override
    public void addMessageItem(MessageItem item) {
        this.items.add((Object)item);
    }

    @Override
    public void addMessageItems(Collection<MessageItem> items) {
        this.items.addAll(items);
    }

    @Override
    public void removeMessageItem(@Nullable MessageItem item) {
        if (item == null) {
            return;
        }
        this.items.remove((Object)item);
    }

    @Override
    public void addOrUpdateMessageItem(int position, MessageItem item) {
        if (position >= 0) {
            this.items.updateItemAt(position, (Object)item);
        } else {
            this.addMessageItem(item);
        }
    }

    @Override
    @Nullable
    public MessageItem getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return (MessageItem)this.items.get(index);
    }

    @Nullable
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        MessageType type = MessageType.fromId(viewType);
        switch (type) {
            case NEW_MESSAGE_DIVIDER: {
                return NewMessageHolder.newInstance(parent);
            }
            case TYPING: {
                return TypingHolder.newInstance(parent);
            }
            case DATE: {
                return DateDividerHolder.newInstance(parent);
            }
            case LOG: {
                return LogMessageHolder.newInstance(parent);
            }
            case SENDING: {
                return SendingMessageHolder.newInstance(parent, type, this.onMessageContentClickListener);
            }
            case HOST: 
            case GUEST: {
                return ChatMessageHolder.newInstance(parent, type, this.onMessageContentClickListener);
            }
            case PROFILE_BOT: {
                return ProfileBotMessageHolder.newInstance(parent, this.onProfileUpdateListener);
            }
            case WELCOME: {
                return WelcomeMessageHolder.newInstance(parent);
            }
            case SUPPORT_BOT: {
                return SupportBotMessageHolder.newInstance(parent, this.onMessageContentClickListener);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        MessageItem item = (MessageItem)this.items.get(position);
        switch (item.getType()) {
            case TYPING: {
                TypingHolder typingHolder = (TypingHolder)holder;
                typingHolder.bind((TypingItem)item);
                break;
            }
            case DATE: {
                DateDividerHolder dateDividerHolder = (DateDividerHolder)holder;
                dateDividerHolder.bind((DateItem)item);
                break;
            }
            case LOG: {
                LogMessageHolder logMessageHolder = (LogMessageHolder)holder;
                logMessageHolder.bind((LogMessageItem)item);
                break;
            }
            case SENDING: {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)item;
                SendingMessageHolder sendingHolder = (SendingMessageHolder)holder;
                sendingHolder.bind((SendingMessageItem)item, sendingMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case HOST: 
            case GUEST: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                ChatMessageHolder chatMessageHolder = (ChatMessageHolder)holder;
                chatMessageHolder.bind(chatMessageItem, chatMessageItem.isConnected(this.getItem(position - 1)), this.isLastPosition(position));
                break;
            }
            case PROFILE_BOT: {
                ProfileBotMessageItem profileItem = (ProfileBotMessageItem)item;
                ProfileBotMessageHolder profileBotMessageHolder = (ProfileBotMessageHolder)holder;
                profileBotMessageHolder.bind(profileItem, this.getChatEditTextFocus());
                break;
            }
            case WELCOME: {
                WelcomeMessageItem welcomeMessageItem = (WelcomeMessageItem)item;
                WelcomeMessageHolder welcomeMessageHolder = (WelcomeMessageHolder)holder;
                welcomeMessageHolder.bind(welcomeMessageItem);
                break;
            }
            case SUPPORT_BOT: {
                SupportBotMessageItem supportBotMessageItem = (SupportBotMessageItem)item;
                SupportBotMessageHolder supportBotMessageHolder = (SupportBotMessageHolder)holder;
                supportBotMessageHolder.bind(supportBotMessageItem, this.isLastPosition(position));
            }
        }
    }

    public boolean isLastPosition(int position) {
        return position == this.getItemCount() - 2;
    }

    public int getItemViewType(int position) {
        return ((MessageItem)this.items.get(position)).getType().toInt();
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public int getIndex(MessageItem item) {
        return this.items.indexOf((Object)item);
    }

    @Override
    @Nullable
    public String getLastMessageItemId() {
        if (this.items.size() > 1) {
            MessageItem messageItem = (MessageItem)this.items.get(this.items.size() - 2);
            return String.format("%s:%s", messageItem.getPrimaryKey(), messageItem.getSecondaryKey());
        }
        return null;
    }

    @Override
    @Nullable
    public WelcomeMessageItem getWelcomeMessageItem() {
        return this.welcomeMessageItem;
    }

    @Override
    @Nullable
    public SupportBotMessageItem getSupportBotItem() {
        return this.supportBotMessageItem;
    }

    @Override
    public void setWelcomeMessage(String message, Long timestamp) {
        if (this.welcomeMessageItem != null) {
            this.items.remove((Object)this.welcomeMessageItem);
        }
        this.welcomeMessageItem = new WelcomeMessageItem(message, timestamp);
        this.addMessageItem(this.welcomeMessageItem);
    }

    @Override
    public void setSupportBotMessage(SupportBotEntry supportBotMessage, Long timestamp) {
        if (this.supportBotMessageItem != null) {
            this.items.remove((Object)this.supportBotMessageItem);
        }
        this.supportBotMessageItem = new SupportBotMessageItem(supportBotMessage, timestamp);
        this.addMessageItem(this.supportBotMessageItem);
    }

    public void setChatEditTextFocus(boolean hasFocus) {
        this.hasChatEditTextFocus = hasFocus;
    }

    private boolean getChatEditTextFocus() {
        return this.hasChatEditTextFocus;
    }

    @Nullable
    public MessageItem get(int position) {
        if (position < 0 || position >= this.items.size()) {
            return null;
        }
        return (MessageItem)this.items.get(position);
    }
}

