/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.LauncherConfig;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.UiStateSelector;
import com.zoyi.channel.plugin.android.util.AlarmCenter;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.CustomTextViewTouchListener;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

class ChannelView
extends FrameLayout {
    public static final int UNDEFINED = -1;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Context context;
    private View pushLayout;
    private AvatarLayout avatarLayout;
    private TextView pushName;
    private TextView pushMessage;
    private TextView pushMessageTime;
    private View fabLayout;
    private CHTextView badge;
    private FloatingActionButton fab;
    @Nullable
    private Subscription subscription;
    @Nullable
    private UserChat userChat;
    private int gravity = -1;
    private int topMargin = -1;
    private int bottomMargin = -1;
    private int leftMargin = -1;
    private int rightMargin = -1;
    private int defaultMargin;

    public ChannelView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(final Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this);
        this.fabLayout = view.findViewById(R.id.fab_layout);
        this.badge = (CHTextView)view.findViewById(R.id.text_badge);
        this.fab = (FloatingActionButton)view.findViewById(R.id.fab);
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelIO.open(context);
            }
        });
        this.defaultMargin = context.getResources().getDimensionPixelSize(R.dimen.ch_default_channel_button_margin);
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelView, 0, 0);
            try {
                this.gravity = typedArray.getInteger(R.styleable.ChannelView_channel_button_gravity, 2);
                this.topMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_top_margin, -1);
                this.bottomMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_bottom_margin, -1);
                this.leftMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_left_margin, -1);
                this.rightMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_right_margin, -1);
                this.setButtonGravity(this.gravity);
            }
            finally {
                if (typedArray != null) {
                    typedArray.recycle();
                }
            }
        }
        this.pushLayout = view.findViewById(R.id.push_layout);
        this.avatarLayout = (AvatarLayout)view.findViewById(R.id.push_avatar);
        this.pushName = (TextView)view.findViewById(R.id.push_name);
        this.pushMessage = (TextView)view.findViewById(R.id.push_message);
        this.pushMessageTime = (TextView)view.findViewById(R.id.push_time);
        view.findViewById(R.id.iv_push_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelView.this.hidePush();
            }
        });
        this.pushLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String chatId = ChannelView.this.userChat != null ? ChannelView.this.userChat.getId() : null;
                ChannelIO.openChat(context, chatId);
                ChannelView.this.hidePush();
            }
        });
    }

    public void setButtonGravity(int gravity) {
        if (!CompareUtils.exists((Comparable)Integer.valueOf(gravity), (Comparable[])new Integer[]{0, 1, 2, 3})) {
            return;
        }
        this.gravity = gravity;
    }

    public void setTopMargin(int topMarginPixel) {
        if (topMarginPixel >= 0) {
            this.topMargin = topMarginPixel;
            this.refreshLayout();
        } else {
            L.e("Margin can't be negative value!");
        }
    }

    public void setBottomMargin(int bottomMarginPixel) {
        if (bottomMarginPixel >= 0) {
            this.bottomMargin = bottomMarginPixel;
            this.refreshLayout();
        } else {
            L.e("Margin can't be negative value!");
        }
    }

    public void setLeftMargin(int leftMarginPixel) {
        if (leftMarginPixel >= 0) {
            this.leftMargin = leftMarginPixel;
            this.refreshLayout();
        } else {
            L.e("Margin can't be negative value!");
        }
    }

    public void setRightMargin(int rightMarginPixel) {
        if (rightMarginPixel >= 0) {
            this.rightMargin = rightMarginPixel;
            this.refreshLayout();
        } else {
            L.e("Margin can't be negative value!");
        }
    }

    public int getTopMargin() {
        if (this.topMargin != -1) {
            return this.topMargin;
        }
        return this.defaultMargin;
    }

    public int getBottomMargin() {
        LauncherConfig config = ChannelIOSelector.getLauncherConfig();
        if (this.bottomMargin != -1) {
            return this.bottomMargin;
        }
        if (config != null) {
            return (int)Utils.dpToPx(this.context, config.getYMargin());
        }
        return this.defaultMargin;
    }

    public int getLeftMargin() {
        LauncherConfig config = ChannelIOSelector.getLauncherConfig();
        if (this.leftMargin != -1) {
            return this.leftMargin;
        }
        if (config != null) {
            return (int)Utils.dpToPx(this.context, config.getXMargin());
        }
        return this.defaultMargin;
    }

    public int getRightMargin() {
        LauncherConfig config = ChannelIOSelector.getLauncherConfig();
        if (this.rightMargin != -1) {
            return this.rightMargin;
        }
        if (config != null) {
            return (int)Utils.dpToPx(this.context, config.getXMargin());
        }
        return this.defaultMargin;
    }

    private int getLauncherGravity() {
        LauncherConfig config = ChannelIOSelector.getLauncherConfig();
        if (this.gravity != -1) {
            return this.gravity;
        }
        if (config != null) {
            return config.getLauncherGravity();
        }
        return 3;
    }

    private void refreshLayout() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        int launcherGravity = this.getLauncherGravity();
        switch (launcherGravity) {
            case 0: 
            case 1: {
                params.addRule(10);
                params.addRule(12, 0);
                break;
            }
            case 2: 
            case 3: {
                params.addRule(12);
                params.addRule(10, 0);
            }
        }
        switch (launcherGravity) {
            case 0: 
            case 2: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20);
                    params.addRule(21, 0);
                }
                params.addRule(9);
                params.addRule(11, 0);
                break;
            }
            case 1: 
            case 3: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20, 0);
                    params.addRule(21);
                }
                params.addRule(9, 0);
                params.addRule(11);
            }
        }
        switch (this.getLauncherGravity()) {
            case 0: {
                params.setMargins(this.getLeftMargin(), this.getTopMargin(), 0, 0);
                break;
            }
            case 1: {
                params.setMargins(0, this.getTopMargin(), this.getRightMargin(), 0);
                break;
            }
            case 2: {
                params.setMargins(this.getLeftMargin(), 0, 0, this.getBottomMargin());
                break;
            }
            case 3: {
                params.setMargins(0, 0, this.getRightMargin(), this.getBottomMargin());
            }
        }
        this.fabLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.fabLayout.requestLayout();
        this.badge.bringToFront();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.refreshLauncherStyle();
        this.refreshStatus();
        this.subscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (o instanceof CommandBus) {
                    CommandBus commandBus = (CommandBus)o;
                    switch (commandBus.getCommand()) {
                        case CHECK_CHANNEL_VIEW_VISIBILITY: {
                            ChannelView.this.refreshStatus();
                            break;
                        }
                        case BOOT: {
                            ChannelView.this.refreshLauncherStyle();
                            ChannelView.this.refreshStatus();
                            break;
                        }
                        case SHUTDOWN: {
                            ChannelView.this.setVisibility(8);
                            ChannelView.this.refreshStatus();
                        }
                    }
                }
                if (o instanceof PushBus) {
                    PushBus pushBus = (PushBus)o;
                    if (ChannelView.this.context != null && ChannelView.this.context == ChannelIO.getTopActivity() && UiStateSelector.shouldShowInDefaultAppPush()) {
                        ChannelView.this.showPush(pushBus.getProfileEntity(), pushBus.getCreatedAt(), pushBus.getMessage(), pushBus.getUserChat());
                    } else {
                        ChannelView.this.hidePush();
                    }
                }
                if (o instanceof StoreBus) {
                    StoreBus storeBus = (StoreBus)o;
                    if (CompareUtils.exists((Comparable)((Object)storeBus.getStoreType()), (Comparable[])new StoreType[]{StoreType.USER, StoreType.VEIL}) && storeBus.getEntity() != null && storeBus.getEntity() instanceof Guest) {
                        Guest guest = (Guest)storeBus.getEntity();
                        ChannelView.this.setBadge(guest.getAlert());
                    }
                    if (storeBus.getStoreType() == StoreType.PLUGIN) {
                        ChannelView.this.refreshLauncherStyle();
                    }
                }
            }
        });
    }

    private boolean isActivityAlive() {
        if (this.context == null) {
            return false;
        }
        if (this.context instanceof Activity) {
            Activity activity = (Activity)this.context;
            if (Build.VERSION.SDK_INT < 17) {
                return !activity.isFinishing() && !activity.isDestroyed();
            }
            return !activity.isFinishing();
        }
        return false;
    }

    private void refreshStatus() {
        if (UiStateSelector.shouldShowDefaultLauncher() && ChannelIO.isBooted() && this.isActivityAlive()) {
            this.setVisibility(0);
            this.refreshLayout();
            this.fabLayout.setVisibility(0);
            this.refreshCount();
        } else {
            this.fabLayout.setVisibility(8);
        }
    }

    private void refreshLauncherStyle() {
        if (ChannelIO.isBooted()) {
            this.fab.setColorNormal(ColorSelector.getBackgroundColor());
            this.fab.setColorPressed(Utils.addBlackMask(ColorSelector.getBackgroundColor()));
            this.fab.setColorRipple(-1);
            this.fab.setImageResource(ColorSelector.getTextColor() == -16777216 ? R.drawable.ch_plugin_balloon_black : R.drawable.ch_plugin_balloon_white);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    public void refreshCount() {
        this.setBadge(CounterSelector.getTotalCounter());
    }

    private void setBadge(int count) {
        if (count <= 0) {
            this.badge.setVisibility(8);
        } else {
            this.badge.setVisibility(0);
            this.badge.setText(Utils.getCount(count, true));
        }
    }

    private void showPush(ProfileEntity person, String createdAt, String message, @Nullable UserChat userChat) {
        this.userChat = userChat;
        if (userChat != null) {
            this.avatarLayout.setVisibility(0);
            this.avatarLayout.set(person);
            this.avatarLayout.setTextSize(14);
            this.pushMessageTime.setText((CharSequence)createdAt);
            if (person != null && person.getName() != null) {
                this.pushName.setText((CharSequence)person.getName());
            } else {
                this.pushName.setText((CharSequence)ResUtils.getString(this.context, "ch.unknown"));
            }
            if (MessageParser.get() != null) {
                SpannableStringBuilder text = MessageParser.get().parse(message);
                this.pushMessage.setOnTouchListener((View.OnTouchListener)new CustomTextViewTouchListener((Spannable)text));
                this.pushMessage.setText((CharSequence)text);
            } else {
                this.pushMessage.setText((CharSequence)message);
            }
            this.pushLayout.setVisibility(0);
            if (PrefSupervisor.isEnabledPushAlarm(this.context)) {
                AlarmCenter.alarm(this.context);
            }
        }
    }

    private void hidePush() {
        this.userChat = null;
        this.pushLayout.setVisibility(8);
    }
}

