package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;

import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Channel implements Entity, ProfileEntity {

  public static final String EXPECTED_RESPONSE_DELAY_INSTANT = "instant";
  public static final String EXPECTED_RESPONSE_DELAY_NORMAL = "normal";
  public static final String EXPECTED_RESPONSE_DELAY_DELAYED = "delayed";

  public static final String PLAN_PRO = "pro";

  private String id;
  private String name;
  private String timeZone;
  private WorkingTime workingTime;
  private TimeRange lunchTime;
  private String homepageUrl;
  private String phoneNumber;
  private String messengerPlan;
  private String pushBotPlan;
  private String supportBotPlan;
  private Boolean blocked;
  private Boolean requestGuestInfo;
  private String expectedResponseDelay;
  private String workingType;
  private String awayOption;
  private Boolean trial;
  private String avatarUrl;
  private Boolean working;

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getName() {
    return name;
  }

  public String getAwayOption() {
    return awayOption;
  }

  public String getWorkingType() {
    return workingType;
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public boolean isWorking() {
    return working;
  }

  public final static String CLASSNAME = "Channel";

  public String getWorkingTime(Context context) {
    String launch = lunchTime != null
      ? String.format(
          "%s: %s",
          ResUtils.getString(context, "ch.out_of_work.lunch_time"),
          TimeUtils.getTimeRangeString(lunchTime))
      : null;

    if (workingTime != null) {
      String work = workingTime.getMessage(context);
      if (launch != null) {
        return String.format("Timezone: %s<br><br>%s<br><br>%s", timeZone, work, launch);
      }
      return String.format("Timezone: %s<br><br>%s", timeZone, work);
    }
    return "";
  }

  public String getHomepageUrl() {
    return homepageUrl;
  }

  public String getPhoneNumber() {
    return phoneNumber;
  }

  public String getMessengerPlan() {
    return messengerPlan;
  }

  public String getPushBotPlan() {
    return pushBotPlan;
  }

  public String getSupportBotPlan() {
    return supportBotPlan;
  }

  public boolean isRequestGuestInfo() {
    return requestGuestInfo;
  }

  public String getExpectedResponseDelay() {
    return expectedResponseDelay;
  }

  public boolean isTrial() {
    if (trial == null) {
      return false;
    }
    return trial;
  }

  public boolean isProMessengerPlan() {
    return PLAN_PRO.equals(getMessengerPlan());
  }

  public boolean canUseMobileSdk() {
    return !blocked && (isTrial() || isProMessengerPlan());
  }
}
