package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by jerry on 2018. 3. 28..
 */

public abstract class BaseMessageHolder extends RecyclerView.ViewHolder {

  @Nullable
  private CHTextView textGuestMessageTime;
  @Nullable
  private View buttonSendingMessageResend;

  @Nullable
  private LinearLayout layoutHostMessageProfile;
  @Nullable
  private AvatarLayout avatarHostMessage;
  @Nullable
  private CHTextView textHostMessageHostName;
  @Nullable
  private CHTextView textHostMessageTime;
  @Nullable
  private LinearLayout layoutHostMessageExtraContent;

  private LinearLayout layoutMessageContent;

  protected Context context;

  protected BaseMessageHolder(View itemView, MessageType messageType) {
    super(itemView);
    this.context = itemView.getContext();

    switch (messageType) {
      case HOST:
      case WELCOME:
      case SUPPORT_BOT:
        layoutHostMessageProfile = itemView.findViewById(R.id.ch_layout_host_message_profile);
        avatarHostMessage = itemView.findViewById(R.id.ch_avater_host_message);
        textHostMessageTime = itemView.findViewById(R.id.ch_text_host_message_time);
        textHostMessageHostName = itemView.findViewById(R.id.ch_text_host_message_name);

        layoutHostMessageExtraContent = itemView.findViewById(R.id.ch_message_content_extra);
        break;

      default:
        textGuestMessageTime = itemView.findViewById(R.id.ch_text_guest_message_time);
        buttonSendingMessageResend = itemView.findViewById(R.id.ch_button_guest_message_resend);
        break;
    }

    layoutMessageContent = itemView.findViewById(R.id.ch_layout_message_content);
  }

  protected void bind(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
    setMessageInfo(message, messageType, isConnectedMessage);
  }

  private void setMessageInfo(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
    switch (messageType) {
      case HOST:
      case WELCOME:
      case SUPPORT_BOT:
        resetHostMessage();
        setHostMessageInfo(message, isConnectedMessage);
        break;

      default:
        resetGuestMessage();
        setGuestMessageInfo(message, isConnectedMessage);
        break;
    }

    resetViews();
    resetMessageContents();
  }

  private void resetGuestMessage() {
    if (buttonSendingMessageResend != null) {
      buttonSendingMessageResend.setVisibility(View.GONE);
    }
  }

  private void resetHostMessage() {
    if (layoutHostMessageExtraContent != null) {
      for (int i = 0; i < layoutHostMessageExtraContent.getChildCount(); i++) {
        layoutHostMessageExtraContent.getChildAt(i).setVisibility(View.GONE);
      }
    }
  }

  private void resetMessageContents() {
    for (int i = 0; i < layoutMessageContent.getChildCount(); i++) {
      layoutMessageContent.getChildAt(i).setVisibility(View.GONE);
    }
  }

  protected abstract void resetViews();

  private void setGuestMessageInfo(@Nullable Message message, boolean isConnectedMessage) {
    if (textGuestMessageTime != null && message != null) {
      Views.setVisibility(textGuestMessageTime, !isConnectedMessage);
      textGuestMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));
    }

    layoutMessageContent.setGravity(Gravity.END);
  }

  protected void setGuestMessageInfo(@Nullable SendingMessageItem messageItem, boolean isConnectedMessage) {
    if (textGuestMessageTime != null && messageItem != null) {
      Views.setVisibility(textGuestMessageTime, !isConnectedMessage);
      textGuestMessageTime.setText(TimeUtils.getTime(messageItem.getCreatedAt()));
    }

    layoutMessageContent.setGravity(Gravity.END);
  }

  private void setHostMessageInfo(@Nullable Message message, boolean isConnectedMessage) {
    if (layoutHostMessageProfile != null &&
        avatarHostMessage != null &&
        textHostMessageTime != null &&
        textHostMessageHostName != null &&
        message != null) {
      textHostMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));

      ProfileEntity profile = ProfileSelector.getPerson(message.getPersonType(), message.getPersonId());

      Views.setVisibility(layoutHostMessageProfile, !isConnectedMessage);
      avatarHostMessage.set(profile);

      String name;
      if (profile != null) {
        name = profile.getName();
      } else {
        name = ResUtils.getString(context, "ch.unknown");
      }
      textHostMessageHostName.setText(name);
    }
  }

  protected void setResendMessageButtonClickListener(View.OnClickListener onClickListener) {
    if (buttonSendingMessageResend != null) {
      buttonSendingMessageResend.setOnClickListener(onClickListener);
    }
  }

  protected void setResendMessageButtonVisibility(boolean isSending) {
    if (buttonSendingMessageResend != null) {
      Views.setVisibility(buttonSendingMessageResend, !isSending);
    }
  }

  protected static View getItemView(ViewGroup parent, MessageType messageType) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());

    switch (messageType) {
      case HOST:
      case WELCOME:
      case SUPPORT_BOT:
        return inflater.inflate(R.layout.ch_plugin_item_message_host, parent, false);

      // Guest, Sending
      default:
        return inflater.inflate(R.layout.ch_plugin_item_message_guest, parent, false);
    }
  }
}
