package com.zoyi.channel.plugin.android.activity.chat.type;

/**
 * Created by mika on 2016. 12. 8..
 */
public enum MessageType {
  DATE(1),
  NEW_MESSAGE_DIVIDER(2),
  TYPING(3),
  SENDING(4),
  LOG(5),
  GUEST(6),
  HOST(7),
  PROFILE_BOT(8),
  WELCOME(9),
  SUPPORT_BOT(10),

  UNKNOWN(100);

  private final int value;
  MessageType(int value) {
    this.value = value;
  }

  public int toInt() {
    return value;
  }

  public static MessageType fromId(int id) {
    for (MessageType type : MessageType.values()) {
      if (type.toInt() == id) {
        return type;
      }
    }
    return UNKNOWN;
  }
}
