package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

import java.util.Map;

import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 22..
 */
public class SendingMessageItem extends ConnectableMessageItem implements MessageItem {

  @Nullable
  private String chatId;

  @Nullable
  private String message;
  @Nullable
  private String mediaFilePath;
  private String requestId;

  private boolean isMediaFile;
  private boolean sending;
  private Long createdAt;
  @Nullable
  private Map<String, String> submit;


  public SendingMessageItem(String requestId, Long createdAt) {
    this.requestId = requestId;
    this.createdAt = createdAt;
  }

  public SendingMessageItem(@Nullable String chatId, boolean isMediaFile) {
    this.requestId = "";
    this.createdAt = 0L;
    this.chatId = chatId;
    this.isMediaFile = isMediaFile;
    this.sending = true;
    refreshCreatedAt();
  }

  @Override
  public Long getPrimaryKey() {
    return createdAt;
  }

  @Override
  public String getSecondaryKey() {
    return requestId;
  }

  @Nullable
  public String getRequestId() {
    return requestId;
  }

  @Override
  public MessageType getType() {
    return MessageType.SENDING;
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  public boolean isSending() {
    return sending;
  }

  public void setSending(boolean sending) {
    this.sending = sending;
  }

  public boolean isMediaFile() {
    return isMediaFile;
  }

  @Nullable
  public static SendingMessageItem create(String requestId) {
    if (requestId == null) {
      return null;
    }

    try {
      return new SendingMessageItem(requestId, Long.parseLong(requestId));
    } catch (Exception ex) {
      return null;
    }
  }

  @Nullable
  public String getMessage() {
    return message;
  }

  public void setMessage(@Nullable String message) {
    this.message = message;
  }

  @Nullable
  public String getMediaFilePath() {
    return mediaFilePath;
  }

  public void setMediaFilePath(@Nullable String mediaFilePath) {
    this.mediaFilePath = mediaFilePath;
  }

  public Long getCreatedAt() {
    return createdAt / 100;
  }

  public void setChatId(String chatId) {
    this.chatId = chatId;
  }

  @Nullable
  public Map<String, String> getSubmit() {
    return submit;
  }

  public void setSubmit(Map<String, String> submit) {
    this.submit = submit;
  }

  private static int count = 0;

  public void refreshCreatedAt() {
    long now = TimeUtils.getCurrentTime() * 100 + (count % 100);
    this.requestId = String.valueOf(now);
    this.createdAt = now;

    count = (count + 1) % 100;
  }

  @Override
  public boolean isSamePerson(@NonNull ConnectableMessageItem item) {
    if (item instanceof SendingMessageItem) {
      return true;
    }
    else if (item instanceof ChatMessageItem) {
      return ((ChatMessageItem) item).getType() == MessageType.GUEST;
    }
    return false;
  }
}
