/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;

public class ChannelPushClient {
    public static void handlePushNotification(final Context context) {
        ChannelPushManager.clearNotification(context);
        if (PrefSupervisor.hasPushChatId(context) && CheckInPrefSupervisor.hasCheckInData(context)) {
            if (ChannelIO.isBooted()) {
                ChannelPushClient.launchChat(context);
            } else if (ChannelIO.isInitializedChannelIO()) {
                ChannelPluginSettings pluginSettings = PrefSupervisor.getPluginSetting(context);
                if (pluginSettings != null) {
                    ChannelIO.boot(pluginSettings, new OnBootListener(){

                        @Override
                        public void onCompletion(ChannelPluginCompletionStatus status, @Nullable Guest guest) {
                            switch (status) {
                                case SUCCESS: {
                                    ChannelPushClient.launchChat(context);
                                    break;
                                }
                                case NOT_INITIALIZED: {
                                    L.e("Push Notification : This plugin is Not initialized");
                                    break;
                                }
                                case NETWORK_TIMEOUT: {
                                    L.e("Push Notification : Network timeout error!");
                                    break;
                                }
                                case INVALID_SETTINGS: {
                                    L.e("Push Notification : Check Plugin Settings");
                                    break;
                                }
                                case NOT_AVAILABLE_VERSION: {
                                    L.e("Push Notification : Check Plugin version");
                                    break;
                                }
                                case SERVICE_UNDER_CONSTRUCTION: {
                                    L.e("Push Notification : Service is now under construction");
                                    break;
                                }
                                default: {
                                    L.e("Push Notification : Unknown error");
                                }
                            }
                        }
                    });
                } else {
                    L.e("Push Notification : This plugin is Not initialized");
                }
            } else {
                L.e("Push Notification : This plugin is Not initialized");
            }
        } else {
            L.e("Push Notification : Invalid push notification data");
        }
    }

    private static void launchChat(Context context) {
        String chatId = PrefSupervisor.getPushChatId(context);
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            if (ChannelIO.isEnabledTrackDefaultEvent() && PluginSelector.getPluginKey() != null) {
                ChannelIO.track(context, PluginSelector.getPluginKey(), "ChannelOpen", null);
            }
            IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("chatId", chatId).startActivity();
        } else {
            L.e("Fail to open ChannelIO messenger, 'chatId' can't be NULL");
        }
        PrefSupervisor.clearPushChatId(context);
    }
}

