/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFileMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnWebMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.FormMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonView;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.WebMessageHolder;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class FormMessageHolder
extends WebMessageHolder
implements View.OnClickListener {
    private Context context;
    private LinearLayout extraMessageContentLayout;
    private FormButtonLayout formButtonLayout;
    private View fileLayout;
    private ImageView fileIconImage;
    private CHTextView fileNameText;
    private CHTextView fileInfoText;
    @Nullable
    private Message message;
    @Nullable
    private OnFormMessageClickListener onFormMessageClickListener;
    @Nullable
    private OnFileMessageClickListener onFileMessageClickListener;
    @Nullable
    private OnWebMessageClickListener onWebMessageClickListener;

    public static FormMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnFileMessageClickListener onFileMessageClickListener, @Nullable OnWebMessageClickListener onWebMessageClickListener, @Nullable OnFormMessageClickListener onFormMEssageClickListener) {
        return new FormMessageHolder(FormMessageHolder.getItemView(parent, messageType), onFileMessageClickListener, onWebMessageClickListener, onFormMEssageClickListener);
    }

    public FormMessageHolder(View itemView, @Nullable OnFileMessageClickListener onFileMessageClickListener, @Nullable OnWebMessageClickListener onWebMessageClickListener, @Nullable OnFormMessageClickListener onFormMessageClickListener) {
        super(itemView, MessageType.FORM_MESSAGE, onWebMessageClickListener);
        this.context = itemView.getContext();
        this.onFileMessageClickListener = onFileMessageClickListener;
        this.onWebMessageClickListener = onWebMessageClickListener;
        this.onFormMessageClickListener = onFormMessageClickListener;
        this.extraMessageContentLayout = (LinearLayout)itemView.findViewById(R.id.ch_message_content_extra);
        this.formButtonLayout = (FormButtonLayout)itemView.findViewById(R.id.ch_layout_form_button);
        this.fileLayout = itemView.findViewById(R.id.ch_message_content_file);
        this.fileIconImage = (ImageView)itemView.findViewById(R.id.icon_file);
        this.fileNameText = (CHTextView)itemView.findViewById(R.id.text_file_name);
        this.fileInfoText = (CHTextView)itemView.findViewById(R.id.text_file_info);
    }

    public void bind(ChatMessageItem chatItem, boolean isLastMessage, boolean isConnected) {
        Message message;
        super.bind(chatItem, isConnected);
        this.message = message = chatItem.getMessage();
        if (message != null) {
            this.setFormMessage(message, isLastMessage);
            File file = message.getFile();
            if (file != null && !file.isImage()) {
                this.setFileMessage(file);
            }
        }
    }

    private void setFormMessage(Message message, boolean isLastMessage) {
        FormMessageItem formMessageItem = new FormMessageItem(message);
        if (!isLastMessage || !ListUtils.hasItems(formMessageItem.getActionInputs())) {
            this.extraMessageContentLayout.setVisibility(8);
        } else {
            this.extraMessageContentLayout.setVisibility(0);
            this.formButtonLayout.removeAllViews();
            this.formButtonLayout.refresh();
            this.formButtonLayout.setWidth(this.getButtonLayoutWidth(this.context));
            for (ActionInput actionInput : formMessageItem.getActionInputs()) {
                this.addFormButton(formMessageItem.getActionType(), actionInput);
            }
        }
    }

    private void setFileMessage(File file) {
        String fileSize = Utils.getProperBytes(file.getSize());
        String fileType = "";
        String extension = file.getExtension();
        if (!"default".equals(extension) && !TextUtils.isEmpty((CharSequence)extension)) {
            fileType = String.format(" \u00b7 %s", extension.substring(0, 1).toUpperCase() + extension.substring(1));
        }
        this.fileLayout.setVisibility(0);
        this.fileLayout.setOnClickListener((View.OnClickListener)this);
        this.fileNameText.setText(file.getFilename());
        this.fileInfoText.setText(String.format("%s%s", fileSize, fileType));
        this.fileIconImage.setImageResource(ResUtils.getFileIconResourceId(file));
    }

    private void addFormButton(@Nullable String actionType, ActionInput actionInput) {
        FormButtonView formButtonView = new FormButtonView(this.context, actionType, actionInput, this.onFormMessageClickListener);
        this.formButtonLayout.add((View)formButtonView);
    }

    private int getButtonLayoutWidth(Context context) {
        int windowWidth = Utils.getWindowSize((Context)context).x;
        int leftPadding = (int)Utils.dpToPx(context, 110.0f);
        int rightPadding = (int)Utils.dpToPx(context, 10.0f);
        return windowWidth - (leftPadding + rightPadding);
    }

    @Override
    public void onClick(View v) {
        if (this.onFileMessageClickListener != null && this.message != null && this.message.getFile() != null) {
            this.onFileMessageClickListener.onFileClick(this.message.getFile());
        }
    }

    @Override
    protected void onImageClick() {
        if (this.onWebMessageClickListener != null && this.message != null) {
            if (this.message.getWebPage() != null) {
                this.onWebMessageClickListener.onWebDescriptionClick(this.message.getWebPage().getUrl());
            } else if (this.message.getFile() != null && this.message.getFile().isImage()) {
                this.onWebMessageClickListener.onImageClick(this.message.getFile());
            }
        }
    }
}

