/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;

public class ChatMessageItem
implements MessageItem {
    private Message message;
    private MessageType type;

    @Initializer
    public ChatMessageItem(Message message) {
        this.message = message;
        if (this.message != null) {
            switch (this.message.getPersonType()) {
                case "Manager": {
                    this.type = this.getManagerMessageType();
                    break;
                }
                case "User": 
                case "Veil": {
                    this.type = this.getGuestMessageType();
                    break;
                }
                case "Bot": {
                    this.type = this.getBotMessageType();
                    break;
                }
                default: {
                    this.type = MessageType.UNKNOWN;
                    break;
                }
            }
        } else {
            this.type = MessageType.UNKNOWN;
        }
    }

    @Override
    public Long getPrimaryKey() {
        if (this.message != null) {
            return this.message.getCreatedAt();
        }
        return 0L;
    }

    @Override
    public String getSecondaryKey() {
        if (this.message != null) {
            return this.message.getId();
        }
        return "";
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    public boolean isConnected(@Nullable MessageItem p2) {
        String t2;
        if (p2 == null || !(p2 instanceof ChatMessageItem)) {
            return false;
        }
        Message m1 = this.message;
        Message m2 = ((ChatMessageItem)p2).getMessage();
        if (m1 == null || m2 == null) {
            return false;
        }
        if (!CompareUtils.isSame(m1.getPersonType(), m2.getPersonType()) || !CompareUtils.isSame(m1.getPersonId(), m2.getPersonId())) {
            return false;
        }
        String t1 = TimeUtils.get(TimeUtils.MINUTE_24, m1.getCreatedAt());
        return CompareUtils.compare(t1, t2 = TimeUtils.get(TimeUtils.MINUTE_24, m2.getCreatedAt())) == 0;
    }

    @Nullable
    public String getPersonType() {
        if (this.message != null) {
            return this.message.getPersonType();
        }
        return null;
    }

    @Nullable
    public String getPersonId() {
        if (this.message != null) {
            return this.message.getPersonId();
        }
        return null;
    }

    private MessageType getGuestMessageType() {
        if (this.message.getWebPage() != null) {
            return MessageType.GUEST_WEB_MESSAGE;
        }
        if (this.message.getFile() != null && this.message.getFile().isImage() && this.message.getFile().getPreviewThumb() != null) {
            return MessageType.GUEST_IMAGE_MESSAGE;
        }
        if (this.message.getFile() != null) {
            return MessageType.GUEST_FILE_MESSAGE;
        }
        return MessageType.GUEST_TEXT_MESSAGE;
    }

    private MessageType getManagerMessageType() {
        if (this.message.getForm() != null) {
            return MessageType.FORM_MESSAGE;
        }
        if (this.message.getWebPage() != null) {
            return MessageType.MANAGER_WEB_MESSAGE;
        }
        if (this.message.getFile() != null && this.message.getFile().isImage() && this.message.getFile().getPreviewThumb() != null) {
            return MessageType.MANAGER_IMAGE_MESSAGE;
        }
        if (this.message.getFile() != null) {
            return MessageType.MANAGER_FILE_MESSAGE;
        }
        return MessageType.MANAGER_TEXT_MESSAGE;
    }

    private MessageType getBotMessageType() {
        if (this.message.getWebPage() != null) {
            return MessageType.BOT_WEB_MESSAGE;
        }
        if (this.message.getFile() != null && this.message.getFile().isImage() && this.message.getFile().getPreviewThumb() != null) {
            return MessageType.BOT_IMAGE_MESSAGE;
        }
        if (this.message.getFile() != null) {
            return MessageType.BOT_FILE_MESSAGE;
        }
        if (this.message.getForm() != null) {
            return MessageType.FORM_MESSAGE;
        }
        return MessageType.BOT_TEXT_MESSAGE;
    }

    public boolean shouldTranslateMessage(@Nullable Message message) {
        Context context = ChannelIO.getAppContext();
        return message != null && context != null && message.getLanguage() != null && !Utils.isSameLanguage(message.getLanguage()) && PrefSupervisor.canTranslateMessage(context);
    }
}

