package com.zoyi.channel.plugin.android.network;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.ChannelWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.CountryWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ManagersWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.*;
import com.zoyi.rx.Observable;

import java.util.Map;

/**
 * Created by mika on 2016. 1. 20..
 */
public interface ChannelApi {
  @GET("packages/{packageId}/versions/latest")
  Observable<PackageWrapper> getLastestPackage(@Path("packageId") String packageId, @Query("from") String from);

  @Headers({"Content-Type: application/json"})
  @POST("/app/plugins/{key}/boot/v2")
  Observable<PluginWrapper> bootV2(@HeaderMap Map<String, String> headers, @Path("key") String key, @Body RequestBody body);

  @GET("/app/plugins/{pluginId}")
  Observable<PluginWrapper> getPlugin(@Path("pluginId") String pluginId);

  @POST("/app/guests/touch")
  Observable<GuestWrapper> touch();

  @GET("/app/user_chats")
  Observable<UserChatsWrapper> getUserChats(@Query("sortField") String sortField, @Query("sortOrder") String sortOrder, @Query("limit") Integer limit, @Query("includeClosed") boolean includeClosed);

  @GET("/app/user_chats/{userChatId}")
  Observable<UserChatWrapper> getUserChat(@Path("userChatId") String userChatId);

  @GET("/app/user_chats/{userChatId}/messages")
  Observable<MessagesWrapper> getMessages(@Path("userChatId") String userChatId, @Query("since") String since, @Query("limit") Integer limit, @Query("sortOrder") String sortOrder);

  @POST("/app/plugins/{pluginId}/user_chats")
  Observable<UserChatWrapper> createUserChat(@Header("X-Plugin-Key") String key, @Path("pluginId") String pluginId, @Query("welcomedAt") long welcomedAt);

  @PUT("/app/user_chats/{userChatId}/messages/read")
  Observable<Void> read(@Path("userChatId") String userChatId, @Query("at") Long at);

  @Headers({"Content-Type: application/json"})
  @POST("/app/user_chats/{userChatId}/messages")
  Observable<MessageWrapper> sendMessage(@Path("userChatId") String userChatId, @Body RequestBody body);

  @Multipart
  @POST("/app/user_chats/{userChatId}/messages/file")
  Observable<MessageWrapper> uploadFile(@Path("userChatId") String userChatId, @Part MultipartBody.Part file, @Part("requestId") RequestBody requestId);

  @Headers({"Content-Type: application/json"})
  @POST("app/device_tokens")
  Observable<Void> sendToken(@Body RequestBody body);

  @Headers({"Content-Type: application/json"})
  @DELETE("app/device_tokens/{platform}/{key}")
  Observable<Void> deleteToken(@Header("X-Guest-Jwt") String jwt, @Path("platform") String platform, @Path("key") String key);

  @Headers({"Content-Type: application/json"})
  @PUT("app/user_chats/{userChatId}/remove")
  Observable<Void> removeUserChat(@Path("userChatId") String userChatId);

  @PUT("app/user_chats/{userChatId}/close")
  Observable<MessageWrapper> closeUserChat(@Path("userChatId") String userChatId, @Nullable @Query("formId") String formId);

  @FormUrlEncoded
  @PUT("app/user_chats/{userChatId}/review")
  Observable<MessageWrapper> reviewUserChat(@Path("userChatId") String userChatId, @Nullable @Query("formId") String formId, @Field("review") String review);

  @GET("/countries")
  Observable<CountryWrapper> getCountries();

  @POST("/app/events")
  Observable<Void> trackEvent(@Body Event event);

  @GET("/app/channels/following_managers")
  Observable<ManagersWrapper> getFollowingManagers();

  @POST("/app/user_chats/{userChatId}/plugins/{pluginId}/profile_bot")
  Observable<Void> requestProfileBot(@Path("userChatId") String userChatId, @Path("pluginId") String pluginId);

  @Headers({"Content-Type: application/json"})
  @POST("/app/messages/{messageId}/profile_bot")
  Observable<MessageWrapper> updateProfileBot(@Path("messageId") String messageId, @Body RequestBody requestBody);

  @GET("app/messages/{messageId}/translate")
  Observable<TranslationRepo> getTranslatedMessage(@Path("messageId") String messageId, @Query("language") String language);
}
