/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import java.util.Map;

public class SendingMessageItem
implements MessageItem {
    @Nullable
    private String chatId;
    @Nullable
    private String string;
    private String requestId;
    private boolean image;
    private boolean sending;
    private Long createdAt;
    @Nullable
    private Map<String, String> submit;
    private static int count = 0;

    public SendingMessageItem(String requestId, Long createdAt) {
        this.requestId = requestId;
        this.createdAt = createdAt;
    }

    public SendingMessageItem(@Nullable String chatId, @Nullable String string2, boolean image) {
        this.requestId = "";
        this.createdAt = 0L;
        this.chatId = chatId;
        this.string = string2;
        this.image = image;
        this.sending = true;
        this.refreshCreatedAt();
    }

    @Override
    public Long getPrimaryKey() {
        return this.createdAt;
    }

    @Override
    public String getSecondaryKey() {
        return this.requestId;
    }

    @Nullable
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public MessageType getType() {
        return MessageType.SENDING;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    public boolean isSending() {
        return this.sending;
    }

    public void setSending(boolean sending) {
        this.sending = sending;
    }

    @Nullable
    public String getString() {
        return this.string;
    }

    public boolean isImage() {
        return this.image;
    }

    @Nullable
    public static SendingMessageItem create(String requestId) {
        if (requestId == null) {
            return null;
        }
        try {
            return new SendingMessageItem(requestId, Long.parseLong(requestId));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public String getMessage() {
        return this.string;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @Nullable
    public Map<String, String> getSubmit() {
        return this.submit;
    }

    public void setSubmit(Map<String, String> submit) {
        this.submit = submit;
    }

    public void refreshCreatedAt() {
        long now = System.currentTimeMillis() * 100L + (long)(count % 100);
        this.requestId = String.valueOf(now);
        this.createdAt = now;
        count = (count + 1) % 100;
    }

    public boolean isConnected(@Nullable MessageItem p2) {
        String t2;
        if (p2 == null || !(p2 instanceof ChatMessageItem)) {
            return false;
        }
        Message m2 = ((ChatMessageItem)p2).getMessage();
        String t1 = TimeUtils.get(TimeUtils.MINUTE_24, System.currentTimeMillis());
        return CompareUtils.compare(t1, t2 = TimeUtils.get(TimeUtils.MINUTE_24, m2.getCreatedAt())) == 0;
    }
}

