/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network;

import com.splunk.mint.network.Metric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MonitorRegistry {
    private Set<Metric<?>> metrics = Collections.synchronizedSet(new HashSet());

    public void add(Metric<?> m) {
        this.metrics.add(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<Metric<?>> getMetricsForName(String name) {
        ArrayList returnedMetrics = new ArrayList();
        Set<Metric<?>> set = this.metrics;
        synchronized (set) {
            Iterator<Metric<?>> it = this.metrics.iterator();
            while (it.hasNext()) {
                String origName;
                Metric<?> metric = it.next();
                int index = metric.getName().indexOf("-");
                if (index >= 0 && (origName = metric.getName().substring(0, index)) != null && name.contains(origName)) {
                    returnedMetrics.add(metric);
                }
                it.remove();
            }
        }
        return returnedMetrics;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        for (Metric<?> m : this.metrics) {
            strBuf.append(m.getName() + " = " + m.getValue() + "\n");
        }
        return strBuf.toString();
    }
}

