/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleFromFuture<T>
implements Single.OnSubscribe<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public SingleFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        T v;
        Future<T> f = this.future;
        t.add(Subscriptions.from(f));
        try {
            v = this.timeout == 0L ? f.get() : f.get(this.timeout, this.unit);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            t.onError(ex);
            return;
        }
        t.onSuccess(v);
    }
}

