package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;

/**
 * Created by jerry on 2018. 8. 21..
 */

public class BottomFloatingActionLayout extends LinearLayout {

  private Context context;

  private View root;
  @Nullable
  private RecyclerView recyclerView;

  @Nullable
  private Channel channel;

  private boolean firstHideAnimation = false;

  public BottomFloatingActionLayout(Context context) {
    super(context);
    init(context);
  }

  public BottomFloatingActionLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public BottomFloatingActionLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  public void init(Context context) {
    this.root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_chat_bottom_frame, this);
    this.context = context;
    this.channel = ChannelSelector.getCurrentChannel();
  }

  public void setRecyclerView(RecyclerView recyclerView) {
    this.recyclerView = recyclerView;
    setRecyclerViewBottomPadding(channel, null);
  }

  public void bindUserChatState(String userChatState) {
    setRecyclerViewBottomPadding(channel, userChatState);
  }

  private void setRecyclerViewBottomPadding(@Nullable Channel channel, @Nullable String userChatState) {
    if (recyclerView != null) {
      int bottomPadding;

      if (CompareUtils.isSame(userChatState, Const.USER_CHAT_STATE_CLOSED)) {
        if (channel != null && channel.isTrial()) {
          bottomPadding = (int) Utils.dpToPx(context, 70); // water mark & new chat button
        } else {
          bottomPadding = (int) Utils.dpToPx(context, 40); // new chat button
        }
      } else {
        if (channel != null && channel.isTrial()) {
          bottomPadding = (int) Utils.dpToPx(context, 30); // water mark
        } else {
          bottomPadding = 0; // None
        }
      }

      recyclerView.setPadding(0, 0, 0, bottomPadding);
    }
  }

  public void show() {
    animateButton(false);
  }

  public void hide() {
    if (!firstHideAnimation) {
      animateButton(true);
    }
  }

  private void animateButton(boolean isHiding) {
    firstHideAnimation = isHiding;
    root.animate().translationY(isHiding ? 300 : 0).start();
  }
}
