/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.splunk.mint.Mint;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.push.ChannelPushClient;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.DataSelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.TokenSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.ChannelIOSettingsStore;
import com.zoyi.channel.plugin.android.store.DataStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.DeviceUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ChannelIO {
    private static final String MINT_DEBUG_KEY = "e72f17f4";
    private static final String MINT_PROD_KEY = "22464da6";
    private static boolean isDebugMode = false;
    private static boolean isEnabledTrackDefaultEvent = true;
    @Nullable
    private static ChannelIO channelIO;
    @Nullable
    private static ChannelApi channelApi;
    private Application application;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    @Nullable
    private ActivityLifecycleManager activityLifecycleManager;
    private AtomicInteger bootCounter = new AtomicInteger(0);

    private ChannelIO(@NonNull Application application) {
        this.application = application;
        this.activityLifecycleManager = new ActivityLifecycleManager();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleManager);
        this.setUncaughtExceptionHandler();
        ChannelIOManager.create(application);
        SocketManager.create(application);
        new GoogleAdIdTask().execute(new Void[0]);
    }

    public static void initialize(@Nullable Application application) {
        if (application == null) {
            L.e("Application can't be NULL");
        } else if (ChannelIO.isInitializedChannelIO()) {
            L.e("Channel plugin already initialized");
        } else {
            channelIO = new ChannelIO(application);
        }
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings) {
        ChannelIO.boot(pluginSettings, null, null);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable OnBootListener completion) {
        ChannelIO.boot(pluginSettings, null, completion);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile) {
        ChannelIO.boot(pluginSettings, profile, null);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, @Nullable OnBootListener completion) {
        if (channelIO != null && pluginSettings != null && pluginSettings.getPluginKey() != null) {
            channelIO.setBootSettings(pluginSettings);
            channelIO.bootProcess(pluginSettings, profile, completion);
        } else {
            L.e("Check plugin information");
        }
    }

    public static void shutdown() {
        if (channelIO != null) {
            channelIO.shutdownProcess();
        }
    }

    public static boolean open(@Nullable Context context) {
        return ChannelIO.open(context, true);
    }

    public static boolean open(@Nullable Context context, boolean animate) {
        if (!ChannelIO.isInitializedChannelIO() || !ChannelIO.isBooted()) {
            L.e("Please check in first");
            return false;
        }
        if (context == null) {
            L.e("Context can't be NULL");
            return false;
        }
        for (ChannelPluginListener l : ChannelIOManager.getChannelPluginListeners()) {
            if (l == null) continue;
            l.willShowMessenger();
        }
        if (ChannelIO.isEnabledTrackDefaultEvent()) {
            ChannelIO.track(context, PluginSelector.getPluginKey(), "ChannelOpen", null);
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("animated", animate).setTransition(animate ? Transition.SLIDE_FROM_BOTTOM : Transition.NONE).startActivity();
        return true;
    }

    public static void close() {
        ChannelIO.close(true);
    }

    public static void close(boolean animated) {
        if (channelIO != null) {
            channelIO.finishAll(animated);
        }
    }

    public static void show() {
        Store.getInstance(ChannelIOSettingsStore.class).setShowLauncher(true);
        RxBus.post(new CommandBus(Command.SHOW_CHANNEL_VIEW));
    }

    public static void hide() {
        Store.getInstance(ChannelIOSettingsStore.class).setShowLauncher(false);
        RxBus.post(new CommandBus(Command.HIDE_CHANNEL_VIEW));
    }

    public static boolean openChat(@Nullable Context context) {
        return ChannelIO.openChat(context, null);
    }

    public static boolean openChat(@Nullable Context context, @Nullable String chatId) {
        return ChannelIO.openChat(context, chatId, true);
    }

    public static boolean openChat(@Nullable Context context, @Nullable String chatId, boolean animate) {
        if (!ChannelIO.isInitializedChannelIO() || !ChannelIO.isBooted()) {
            L.e("Please Boot first");
            return false;
        }
        if (context == null) {
            L.e("Context can't be NULL");
            return false;
        }
        if (ChannelIO.isEnabledTrackDefaultEvent()) {
            ChannelIO.track(context, PluginSelector.getPluginKey(), "ChannelOpen", null);
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("chatId", chatId).putExtra("animated", animate).setTransition(animate ? Transition.SLIDE_FROM_BOTTOM : Transition.NONE).startActivityForResult(21);
        return true;
    }

    public static void handlePushNotification(Context context) {
        ChannelPushClient.handlePushNotification(context);
    }

    public static void showPushNotification(Context context, Map<String, String> message) {
        ChannelPushManager.showPushNotification(context, message);
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(message);
    }

    private void setUncaughtExceptionHandler() {
        this.uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (Looper.getMainLooper().getThread() == thread) {
                    ChannelIO.this.uncaughtExceptionHandler.uncaughtException(thread, ex);
                } else if (ex instanceof RejectedExecutionException) {
                    SocketManager.reconnect();
                }
            }
        });
    }

    private void setBootSettings(ChannelPluginSettings pluginSettings) {
        isDebugMode = pluginSettings.isDebugMode();
        isEnabledTrackDefaultEvent = pluginSettings.isEnabledTrackDefaultEvent();
        if (this.application != null) {
            PrefSupervisor.setPluginLanguage((Context)this.application, pluginSettings.getLocale());
            PrefSupervisor.setPluginSetting((Context)this.application, pluginSettings);
        }
    }

    private void bootProcess(ChannelPluginSettings pluginSettings, @Nullable Profile profile, @Nullable OnBootListener listener) {
        if (ChannelIO.isBooted()) {
            this.shutdownProcess();
        }
        this.checkVersion(pluginSettings, profile, listener);
    }

    private void checkVersion(final ChannelPluginSettings pluginSettings, final @Nullable Profile profile, final @Nullable OnBootListener listener) {
        final int counter = this.bootCounter.incrementAndGet();
        ChannelIO.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "4.0.0").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PackageWrapper>(){

            @Override
            public void onError(Throwable error) {
                if (counter != ChannelIO.this.bootCounter.get()) {
                    return;
                }
                if (listener != null) {
                    listener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
                }
            }

            @Override
            public void onNext(PackageWrapper wrapper) {
                if (counter != ChannelIO.this.bootCounter.get()) {
                    return;
                }
                if (!wrapper.isNeedToUpgrade()) {
                    if (!CompareUtils.isSame(wrapper.getVersionString(), "4.0.0")) {
                        L.i("Newest version is: " + wrapper.getVersionString());
                    }
                    ChannelIO.this.bootChannelIO(pluginSettings, profile, listener, counter);
                } else if (listener != null) {
                    listener.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION, null);
                }
            }
        });
    }

    private void bootChannelIO(final ChannelPluginSettings pluginSettings, final @Nullable Profile profile, final @Nullable OnBootListener listener, final int counter) {
        String pluginKey = pluginSettings.getPluginKey();
        if (pluginKey != null) {
            String wId;
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            bodyMap.put("userId", pluginSettings.getUserId());
            if (profile != null) {
                HashMap<String, Object> profileMap = new HashMap<String, Object>();
                profileMap.put("name", profile.getName());
                profileMap.put("avatarUrl", profile.getAvatarUrl());
                profileMap.put("avatarUrl", profile.getMobileNumber());
                for (Map.Entry<String, Object> entry : profile.getProperty().entrySet()) {
                    profileMap.put(entry.getKey(), entry.getValue());
                }
                bodyMap.put("profile", profileMap);
            }
            HashMap<String, String> sysProfileMap = new HashMap<String, String>();
            sysProfileMap.put("platform", "android");
            sysProfileMap.put("version", "4.0.0");
            if (DataSelector.getAdId() != null) {
                sysProfileMap.put("adId", DataSelector.getAdId());
            }
            if ((wId = DeviceUtils.getWId((Context)this.application)) != null) {
                sysProfileMap.put("wId", wId);
            }
            bodyMap.put("sysProfile", sysProfileMap);
            HashMap<String, String> headers = new HashMap<String, String>();
            String veilId = GuestSelector.getVeilId();
            if (!TextUtils.isEmpty((CharSequence)veilId)) {
                headers.put("X-Veil-Id", veilId.substring(0, 16));
            }
            ChannelIO.getApi().bootV2(headers, pluginKey, RequestUtils.form(bodyMap).create()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

                @Override
                public void onError(RetrofitException e) {
                    if (counter != ChannelIO.this.bootCounter.get()) {
                        return;
                    }
                    L.e(e.getMessage());
                    if (listener != null) {
                        ChannelPluginCompletionStatus status = e.isConnectionError() ? ChannelPluginCompletionStatus.NETWORK_TIMEOUT : (e.isHttpError() ? ChannelPluginCompletionStatus.NOT_INITIALIZED : ChannelPluginCompletionStatus.UNKNOWN_ERROR);
                        listener.onCompletion(status, null);
                    }
                }

                @Override
                public void onNext(PluginWrapper repo) {
                    if (counter == ChannelIO.this.bootCounter.get() && repo != null && repo.isValid()) {
                        repo.set();
                        Store.getInstance(ChannelIOSettingsStore.class).setSettings(pluginSettings);
                        Channel channel = repo.getChannel();
                        Plugin plugin = repo.getPlugin();
                        if (pluginSettings.getUserId() != null) {
                            CheckInPrefSupervisor.setProfile((Context)ChannelIO.this.application, pluginSettings.getUserId(), profile);
                        }
                        CheckInPrefSupervisor.setVeil((Context)ChannelIO.this.application, repo.getVeil());
                        ChannelIOManager.bootPlugin(repo);
                        ChannelIO.this.initBugTracking(channel);
                        ChannelPushManager.sendTokenToChannelIO((Context)ChannelIO.this.application);
                        SocketManager.setChannelId(channel.getId());
                        SocketManager.connect();
                        RxBus.post(new CommandBus(Command.BOOT));
                        if (pluginSettings.isEnabledTrackDefaultEvent()) {
                            ChannelIO.track((Context)ChannelIO.this.application, pluginSettings.getPluginKey(), "Boot", null);
                        }
                        if (listener != null) {
                            listener.onCompletion(ChannelPluginCompletionStatus.SUCCESS, repo.getUser() != null ? repo.getUser() : repo.getVeil());
                        }
                    }
                }
            });
        }
    }

    private void shutdownProcess() {
        this.bootCounter.incrementAndGet();
        String jwt = TokenSelector.getJwt();
        ChannelPushManager.deleteToken((Context)this.application, jwt);
        CheckInPrefSupervisor.clear((Context)this.application);
        Store.destroy();
        RxBus.post(new CommandBus(Command.SHUTDOWN));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        ChatManager.release();
        this.releaseBugTracking();
    }

    private void finishAll(boolean animated) {
        if (this.activityLifecycleManager != null) {
            this.activityLifecycleManager.finish(animated);
        }
    }

    @Nullable
    static Activity getTopActivity() {
        if (channelIO != null && ChannelIO.channelIO.activityLifecycleManager != null) {
            return ChannelIO.channelIO.activityLifecycleManager.getTopActivity();
        }
        return null;
    }

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    private void initBugTracking(Channel channel) {
        if (this.application != null) {
            Mint.disableNetworkMonitoring();
            Mint.initAndStartSession((Application)this.application, (String)MINT_PROD_KEY);
            Mint.addExtraData((String)"plugin_version", (String)"4.0.0");
            if (channel != null) {
                Mint.addExtraData((String)"channel_id", (String)channel.getId());
                Mint.addExtraData((String)"channel_name", (String)channel.getName());
            }
        }
    }

    private void releaseBugTracking() {
        if (this.application != null) {
            Mint.clearExtraData();
            Mint.closeSession((Application)this.application);
            Mint.flush();
        }
    }

    public static void track(@Nullable Context context, @Nullable String pluginKey, @NonNull @Size(min=1L, max=30L) String eventName, @Nullable Map<String, Object> eventProperty) {
        if (TextUtils.isEmpty((CharSequence)eventName) || eventName.length() > 30) {
            return;
        }
        ChannelIO.track(new Event(context, pluginKey, eventName, eventProperty));
    }

    private static void track(@NonNull Event event) {
        ChannelIO.getApi().trackEvent(event).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
    }

    public static boolean isInitializedChannelIO() {
        return channelIO != null;
    }

    @Nullable
    public static Context getAppContext() {
        if (channelIO != null) {
            return ChannelIO.channelIO.application.getApplicationContext();
        }
        return null;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isEnabledTrackDefaultEvent() {
        return isEnabledTrackDefaultEvent;
    }

    @Deprecated
    public static boolean isDataStored() {
        return ChannelIO.isBooted();
    }

    public static boolean isBooted() {
        return ChannelIOSelector.isBooted();
    }

    public static void updateGuest() {
        ChannelIO.updateGuest(null);
    }

    public static void updateGuest(@Nullable OnGuestUpdatedListener listener) {
        ChannelIOManager.fetchMe(listener);
    }

    public static void addChannelPluginListener(ChannelPluginListener listener) {
        ChannelIOManager.addChannelPluginListener(listener);
    }

    public static void removeChannelPluginListener(ChannelPluginListener listener) {
        ChannelIOManager.removeChannelPluginListener(listener);
    }

    private class GoogleAdIdTask
    extends AsyncTask<Void, Void, String> {
        private GoogleAdIdTask() {
        }

        @Nullable
        protected String doInBackground(Void ... params) {
            try {
                AdvertisingIdClient.Info advertisingIdInfo;
                if (ChannelIO.this.application != null && (advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)ChannelIO.this.application)) != null && !advertisingIdInfo.isLimitAdTrackingEnabled()) {
                    return advertisingIdInfo.getId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        protected void onPostExecute(String adId) {
            if (adId != null) {
                Store.getInstance(DataStore.class).setAdId(adId);
            }
        }
    }
}

