package com.zoyi.channel.plugin.android.store;

import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.model.entity.Entity;

/**
 * Created by mika on 2018. 6. 18..
 */

public abstract class SingleStore<E extends Entity> extends Store {

  protected E data;

  public synchronized E get() {
    return data;
  }

  public synchronized void set(E e) {
    data = e;

    if (e != null) {
      RxBus.post(new StoreBus<>(getStoreType(), UpdateType.UPDATE, e));
    }
  }

  public synchronized void update(E e) {
    if (e != null && canUpdate(e)) {
      data = e;

      RxBus.post(new StoreBus<>(getStoreType(), UpdateType.UPDATE, e));
    }
  }

  protected boolean canUpdate(E e) {
    return data != null && e != null && data.getId() != null && data.getId().equals(e.getId());
  }

  public synchronized boolean isExists() {
    return data != null;
  }

  @Override
  public void clearData() {
    data = null;
  }
}
