package com.zoyi.channel.plugin.android.model.etc;

import com.zoyi.channel.plugin.android.event.PushBus;

/**
 * Created by jerry on 2018. 2. 22..
 */

public class PushEvent {

  private String chatId;
  private String senderAvatarUrl;
  private String senderName;
  private String message;

  public PushEvent(PushBus pushBus) {
    this.chatId = pushBus.getUserChat().getId();
    this.senderName = pushBus.getProfileEntity().getName();
    this.senderAvatarUrl = pushBus.getProfileEntity().getAvatarUrl();
    this.message = pushBus.getMessage();
  }

  public String getChatId() {
    return chatId;
  }

  public String getSenderAvatarUrl() {
    return senderAvatarUrl;
  }

  public String getMessage() {
    return message;
  }

  public String getSenderName() {
    return senderName;
  }
}
