/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings.setting_language;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.settings.setting_language.SettingLanguagePresenter;
import com.zoyi.channel.plugin.android.activity.settings.setting_language.listener.OnLanguageItemClickListener;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.SelectableLanguageItem;
import java.util.ArrayList;
import java.util.List;

public class SettingLanguageActivity
extends BaseActivity
implements OnLanguageItemClickListener {
    private SettingLanguagePresenter presenter;
    private LinearLayout contentLayout;
    private List<CHLocale> channelLanguages;
    private CHLocale selectedChannelLanguage;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_setting_language);
        this.presenter = new SettingLanguagePresenter();
        this.initData();
        this.initView();
    }

    private void initData() {
        this.channelLanguages = new ArrayList<CHLocale>();
        this.channelLanguages.add(CHLocale.KOREAN);
        this.channelLanguages.add(CHLocale.JAPANESE);
        this.channelLanguages.add(CHLocale.ENGLISH);
        this.selectedChannelLanguage = CHLocale.fromString(PrefSupervisor.getPluginLanguage((Context)this));
    }

    private void initView() {
        if (this.getBigBar() != null) {
            this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT).build();
            this.getBigBar().setTitleByKey("ch.user_profile.locale.label");
        }
        this.contentLayout = (LinearLayout)this.findViewById(R.id.ch_layout_setting_language);
        for (CHLocale channelLanguage : this.channelLanguages) {
            SelectableLanguageItem selectableLanguageItem = new SelectableLanguageItem((Context)this);
            selectableLanguageItem.setLanguage(channelLanguage);
            selectableLanguageItem.setListener(this);
            selectableLanguageItem.setSelectedLanguage(this.selectedChannelLanguage == channelLanguage);
            this.contentLayout.addView((View)selectableLanguageItem);
        }
    }

    @Override
    public void onItemClick(CHLocale channelLanguage) {
        this.selectedChannelLanguage = channelLanguage;
        for (int i = 0; i < this.contentLayout.getChildCount(); ++i) {
            SelectableLanguageItem languageItem = (SelectableLanguageItem)this.contentLayout.getChildAt(i);
            if (this.selectedChannelLanguage == languageItem.getLanguage()) continue;
            languageItem.setStyle(false);
        }
        this.presenter.changeLanguage((Context)this, this.selectedChannelLanguage);
        this.setResult(30);
        this.finish();
    }
}

