/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.BaseMessageHolder;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class TextMessageHolder
extends BaseMessageHolder {
    @Nullable
    protected MaskableFrameLayout guestMessageHeadLayout;
    @Nullable
    protected MaskableFrameLayout guestMessageContentLayout;
    @Nullable
    protected CHTextView guestMessageText;
    @Nullable
    protected View guestMessageTopView;
    @Nullable
    protected View guestMessageContentView;
    @Nullable
    protected View managerMessageHeadTop;
    @Nullable
    protected View managerMessageContextTop;
    @Nullable
    protected CHTextView managerMessageText;

    public static TextMessageHolder newInstance(ViewGroup parent, MessageType messageType) {
        return new TextMessageHolder(TextMessageHolder.getItemView(parent, messageType), messageType);
    }

    public TextMessageHolder(View itemView, MessageType messageType) {
        super(itemView, messageType);
        switch (messageType) {
            case GUEST_TEXT_MESSAGE: 
            case GUEST_IMAGE_MESSAGE: 
            case GUEST_FILE_MESSAGE: 
            case GUEST_WEB_MESSAGE: {
                this.guestMessageHeadLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_layout_guest_message_head);
                this.guestMessageContentLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_layout_guest_message_content);
                this.guestMessageText = (CHTextView)itemView.findViewById(R.id.ch_text_guest_message);
                this.guestMessageTopView = itemView.findViewById(R.id.ch_view_guest_message_head_top);
                this.guestMessageContentView = itemView.findViewById(R.id.ch_view_guest_message_content_top);
                break;
            }
            default: {
                this.managerMessageHeadTop = itemView.findViewById(R.id.ch_view_manager_message_head_top);
                this.managerMessageContextTop = itemView.findViewById(R.id.ch_view_manager_message_context_top);
                this.managerMessageText = (CHTextView)itemView.findViewById(R.id.ch_text_manager_message);
            }
        }
    }

    public void bind(ChatMessageItem item, boolean isConnectedMessage) {
        super.bind(item.getMessage(), item.getType(), isConnectedMessage);
        switch (item.getType()) {
            case GUEST_TEXT_MESSAGE: 
            case GUEST_IMAGE_MESSAGE: 
            case GUEST_FILE_MESSAGE: 
            case GUEST_WEB_MESSAGE: {
                this.setGuestMessageText(item, isConnectedMessage);
                break;
            }
            default: {
                this.setManagerMessageText(item, isConnectedMessage);
            }
        }
    }

    private void setGuestMessageText(ChatMessageItem item, boolean isConnectedMessage) {
        if (item.getMessage().getMessage() != null && this.guestMessageTextLayout != null && this.guestMessageHeadLayout != null && this.guestMessageContentLayout != null && this.guestMessageText != null && this.guestMessageTopView != null && this.guestMessageContentView != null) {
            this.guestMessageTextLayout.setVisibility(0);
            this.guestMessageHeadLayout.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
            this.guestMessageContentLayout.setVisibility(UIUtils.getVisible(isConnectedMessage, true));
            this.guestMessageTopView.setBackgroundColor(ColorSelector.getBackgroundColor());
            this.guestMessageContentView.setBackgroundColor(ColorSelector.getBackgroundColor());
            this.guestMessageText.setBackgroundColor(ColorSelector.getBackgroundColor());
            this.guestMessageText.setMovementMethod(LinkMovementMethod.getInstance());
            this.guestMessageText.setText((CharSequence)item.getMessage().getFormattedSpanMessage());
            this.guestMessageText.setLinkTextColor(ColorSelector.getTextColor());
            this.guestMessageText.setTextColor(ColorSelector.getTextColor());
        }
    }

    private void setManagerMessageText(ChatMessageItem item, boolean isConnectedMessage) {
        if (item.getMessage().getMessage() != null && this.managerMessageTextLayout != null && this.managerMessageHeadTop != null && this.managerMessageContextTop != null && this.managerMessageText != null) {
            this.managerMessageTextLayout.setVisibility(0);
            this.managerMessageHeadTop.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
            this.managerMessageContextTop.setVisibility(UIUtils.getVisible(isConnectedMessage, true));
            this.managerMessageText.setText((CharSequence)item.getMessage().getFormattedSpanMessage());
            this.managerMessageText.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }
}

