package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import java.io.File;
import java.util.Locale;

/**
 * Created by mika on 2016. 4. 19..
 */
public class Utils {
  public static int addBlackMask(int color) {
    float[] hsv = new float[3];
    Color.colorToHSV(color, hsv);
    hsv[2] = Math.max(0, hsv[2] - 0.2f);
    return Color.HSVToColor(hsv);
  }

  public static Point getImageArea(String imagePath) {
    BitmapFactory.Options options = new BitmapFactory.Options();
    options.inJustDecodeBounds = true;
    BitmapFactory.decodeFile(new File(imagePath).getAbsolutePath(), options);
    return new Point(options.outWidth, options.outHeight);
  }

  public static Point resizeImage(Context context, Point imageArea) {

    double ratioWidth = 1.0;
    double ratioHeight = 1.0;

    int targetWidth = imageArea.x;
    int targetHeight = imageArea.y;

    Point windowSize = Utils.getWindowSize(context);

    if (windowSize.x == 0 || windowSize.y == 0) {
      return new Point(targetWidth, targetHeight);
    }

    double minWidth = windowSize.x * 5.3 / 10;
    double maxWidth = windowSize.x * 6.5 / 10;
    double minHeight = windowSize.y * 1.5 / 10;
    double maxHeight = windowSize.y * 4.5 / 10;

    if (targetWidth > maxWidth) {
      ratioWidth = maxWidth / targetWidth;
    } else if (targetWidth < minWidth) {
      ratioWidth = minWidth / targetWidth;
    }

    if (targetHeight > maxHeight) {
      ratioHeight = maxHeight / targetHeight;
    } else if (targetHeight < minWidth) {
      ratioHeight = minHeight / targetHeight;
    }

    if (ratioWidth > 1.0 && ratioHeight < 1.0) {
      return new Point((int) minWidth, (int) maxHeight);
    }
    if (ratioWidth < 1.0 && ratioHeight > 1.0) {
      return new Point((int) maxWidth, (int) minHeight);
    }

    if (ratioWidth < 1.0 || ratioHeight < 1.0) {
      double ratioMin = Math.min(ratioWidth, ratioHeight);
      targetWidth = Math.max((int) minWidth, (int) (targetWidth * ratioMin));
      targetHeight = Math.max((int) minHeight, (int) (targetHeight * ratioMin));
    } else if (ratioWidth > 1.0 || ratioHeight > 1.0) {
      double ratioMax = Math.max(ratioWidth, ratioHeight);
      targetWidth = Math.min((int) maxWidth, (int) (targetWidth * ratioMax));
      targetHeight = Math.min((int) maxHeight, (int) (targetHeight * ratioMax));
    }
    return new Point(targetWidth, targetHeight);
  }

  public static Point getWindowSize(Context context) {
    Point windowSize = new Point();
    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    wm.getDefaultDisplay().getSize(windowSize);
    return windowSize;
  }

  public static String getProperBytes(long bytes) {
    if (bytes < 1000) {
      return String.format(Locale.US, "%dB", bytes);
    } else if (bytes <= 1000000) {
      return String.format(Locale.US, "%.1fKB", bytes / 1000.0);
    } else if (bytes <= 1000000000) {
      return String.format(Locale.US, "%.1fMB", bytes / 1000000.0);
    } else {
      return String.format(Locale.US, "%.1fGB", bytes / 1000000000.0);
    }
  }

  public static float dpToPx(Context context, float dp) {
    Resources resources = context.getResources();
    DisplayMetrics metrics = resources.getDisplayMetrics();
    return dp * ((float) metrics.densityDpi / DisplayMetrics.DENSITY_DEFAULT);
  }

  public static String getCount(int count, boolean emptyIfZero) {
    return getCount((long) count, emptyIfZero);
  }

  public static String getCount(long count, boolean emptyIfZero) {
    if (count <= 0 && emptyIfZero) {
      return "";
    }
    return count >= 100 ? "99+" : String.valueOf(count);
  }

  public static Spanned getHtmlFormattedText(String text) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
      return Html.fromHtml(text, Html.FROM_HTML_MODE_LEGACY);
    }
    return Html.fromHtml(text);
  }
}
