package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.store.*;

/**
 * Created by mika on 2018. 6. 20..
 */

public class ChannelIOSelector extends BaseSelector {

  public static boolean isBooted() {
    Plugin plugin = Store.getInstance(PluginStore.class).get();
    Channel channel = Store.getInstance(ChannelStore.class).get();
    User user = Store.getInstance(UserStore.class).get();
    Veil veil = Store.getInstance(VeilStore.class).get();

    return plugin != null && channel != null && !channel.isSdkPluginBlocked() && (user != null || veil != null);
  }

  public static boolean shouldShowDefaultLauncherOnInit() {
    ChannelPluginSettings settings = Store.getInstance(ChannelIOSettingsStore.class).getSettings();
    Plugin plugin = Store.getInstance(PluginStore.class).get();
    Channel channel = Store.getInstance(ChannelStore.class).get();
    Boolean showLauncher = Store.getInstance(ChannelIOSettingsStore.class).isShowLauncher();

    if (showLauncher != null) {
      return showLauncher;
    }

    return settings != null
        && !settings.isHideDefaultLauncher()
        && plugin != null
        && !plugin.isHideLauncher()
        && channel != null
        && !channel.isHideLauncher();
  }

  public static boolean shouldShowInAppPush() {
    ChannelPluginSettings settings = Store.getInstance(ChannelIOSettingsStore.class).getSettings();

    return settings != null && !settings.isHideDefaultInAppPush();
  }
}
