/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.BaseMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class FileMessageHolder
extends BaseMessageHolder
implements View.OnClickListener {
    protected View fileLayout;
    protected ImageView fileIconImage;
    protected CHTextView fileNameText;
    protected CHTextView fileInfoText;
    @Nullable
    private Message message;
    @Nullable
    private OnMessageClickListener listener;

    public static FileMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnMessageClickListener listener) {
        return new FileMessageHolder(FileMessageHolder.getItemView(parent, messageType), messageType, listener);
    }

    public FileMessageHolder(View itemView, MessageType messageType, @Nullable OnMessageClickListener listener) {
        super(itemView, messageType);
        this.listener = listener;
        this.fileLayout = itemView.findViewById(R.id.ch_message_content_file);
        this.fileIconImage = (ImageView)itemView.findViewById(R.id.icon_file);
        this.fileNameText = (CHTextView)itemView.findViewById(R.id.text_file_name);
        this.fileInfoText = (CHTextView)itemView.findViewById(R.id.text_file_info);
    }

    public void bind(ChatMessageItem item, boolean isConnectedMessage) {
        File file;
        super.bind(item.getMessage(), item.getType(), isConnectedMessage);
        this.message = item.getMessage();
        if (this.message != null && (file = this.message.getFile()) != null) {
            this.setFileMessage(file);
        }
    }

    private void setFileMessage(File file) {
        String fileSize = Utils.getProperBytes(file.getSize());
        String fileType = "";
        String extension = file.getExtension();
        if (!"default".equals(extension) && !TextUtils.isEmpty((CharSequence)extension)) {
            fileType = String.format(" \u00b7 %s", extension.substring(0, 1).toUpperCase() + extension.substring(1));
        }
        this.fileLayout.setVisibility(0);
        this.fileLayout.setOnClickListener((View.OnClickListener)this);
        this.fileNameText.setText(file.getFilename());
        this.fileInfoText.setText(String.format("%s%s", fileSize, fileType));
        this.fileIconImage.setImageResource(ResUtils.getFileIconResourceId(file));
    }

    public void onClick(View v) {
        if (this.listener != null && this.message != null) {
            this.listener.messageClicked(this.message);
        }
    }
}

