/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.util.AlarmCenter;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

public class ChannelView
extends RelativeLayout {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Context context;
    private View pushLayout;
    private AvatarLayout avatarLayout;
    private View reviewAvatar;
    private CHTextView pushName;
    private CHTextView pushMessage;
    private View fabLayout;
    private CHTextView badge;
    private FloatingActionButton fab;
    private Animation pushAnimation;
    @Nullable
    private Subscription subscription;
    @Nullable
    private UserChat userChat;
    private int gravity;
    private int topMargin;
    private int bottomMargin;
    private int leftMargin;
    private int rightMargin;

    public ChannelView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(final Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this);
        this.fabLayout = view.findViewById(R.id.fab_layout);
        this.badge = (CHTextView)view.findViewById(R.id.text_badge);
        this.fab = (FloatingActionButton)view.findViewById(R.id.fab);
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelIO.open(context);
            }
        });
        int defaultMargin = context.getResources().getDimensionPixelSize(R.dimen.ch_default_channel_button_margin);
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelView, 0, 0);
            try {
                this.gravity = typedArray.getInteger(R.styleable.ChannelView_channel_button_gravity, 3);
                this.topMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_top_margin, defaultMargin);
                this.bottomMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_bottom_margin, defaultMargin);
                this.leftMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_left_margin, defaultMargin);
                this.rightMargin = typedArray.getDimensionPixelSize(R.styleable.ChannelView_channel_button_right_margin, defaultMargin);
                this.setTopMargin(this.topMargin);
                this.setBottomMargin(this.bottomMargin);
                this.setLeftMargin(this.leftMargin);
                this.setRightMargin(this.rightMargin);
                this.setButtonGravity(this.gravity);
            }
            finally {
                if (typedArray != null) {
                    typedArray.recycle();
                }
            }
        }
        this.pushLayout = view.findViewById(R.id.push_layout);
        this.avatarLayout = (AvatarLayout)view.findViewById(R.id.push_avatar);
        this.reviewAvatar = view.findViewById(R.id.iv_review_avatar);
        this.pushName = (CHTextView)view.findViewById(R.id.push_name);
        this.pushMessage = (CHTextView)view.findViewById(R.id.push_message);
        this.pushAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_push);
        this.pushAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
                ChannelView.this.pushLayout.setVisibility(0);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                ChannelView.this.hidePush();
            }
        });
        view.findViewById(R.id.iv_push_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelView.this.hidePush();
            }
        });
        this.pushLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String chatId = ChannelView.this.userChat != null ? ChannelView.this.userChat.getId() : null;
                ChannelIO.openChat(context, chatId);
            }
        });
    }

    public void setButtonGravity(int gravity) {
        if (!CompareUtils.exists((Comparable)Integer.valueOf(gravity), (Comparable[])new Integer[]{0, 1, 2, 3})) {
            return;
        }
        this.gravity = gravity;
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.fabLayout.getLayoutParams();
        switch (gravity) {
            case 0: 
            case 1: {
                params.addRule(10);
                params.addRule(12, 0);
                break;
            }
            case 2: 
            case 3: {
                params.addRule(12);
                params.addRule(10, 0);
            }
        }
        switch (gravity) {
            case 0: 
            case 2: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20);
                    params.addRule(21, 0);
                }
                params.addRule(9);
                params.addRule(11, 0);
                break;
            }
            case 1: 
            case 3: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20, 0);
                    params.addRule(21);
                }
                params.addRule(9, 0);
                params.addRule(11);
            }
        }
        this.fabLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.fabLayout.requestLayout();
        this.badge.bringToFront();
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
        this.refreshSize();
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
        this.refreshSize();
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        this.refreshSize();
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
        this.refreshSize();
    }

    private void refreshSize() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.fabLayout.getLayoutParams();
        switch (this.gravity) {
            case 0: {
                params.setMargins(this.leftMargin, this.topMargin, 0, 0);
                break;
            }
            case 1: {
                params.setMargins(0, this.topMargin, this.rightMargin, 0);
                break;
            }
            case 2: {
                params.setMargins(this.leftMargin, 0, 0, this.bottomMargin);
                break;
            }
            case 3: {
                params.setMargins(0, 0, this.rightMargin, this.bottomMargin);
            }
        }
        this.fabLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.fabLayout.requestLayout();
        this.badge.bringToFront();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initView();
        this.subscription = RxBus.observable().onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                StoreBus storeBus;
                if (o instanceof CommandBus) {
                    CommandBus commandBus = (CommandBus)o;
                    switch (commandBus.getCommand()) {
                        case SHOW_CHANNEL_VIEW: {
                            ChannelView.this.showLauncherButton();
                            break;
                        }
                        case HIDE_CHANNEL_VIEW: {
                            ChannelView.this.hideLauncherButton();
                            break;
                        }
                        case BOOT: {
                            ChannelView.this.initView();
                            break;
                        }
                        case SHUTDOWN: {
                            ChannelView.this.shutdown();
                        }
                    }
                }
                if (o instanceof PushBus) {
                    PushBus pushBus = (PushBus)o;
                    if (!ChannelIOManager.isMainRunning() && ChannelIOSelector.shouldShowInAppPush()) {
                        ChannelView.this.showPush(pushBus.getProfileEntity(), pushBus.getMessage(), pushBus.getUserChat());
                    }
                }
                if (o instanceof StoreBus && CompareUtils.exists((Comparable)((Object)(storeBus = (StoreBus)o).getStoreType()), (Comparable[])new StoreType[]{StoreType.USER, StoreType.VEIL}) && storeBus.getEntity() != null && storeBus.getEntity() instanceof Guest) {
                    Guest guest = (Guest)storeBus.getEntity();
                    ChannelView.this.setBadge(guest.getAlert());
                }
            }
        });
    }

    private void initView() {
        if (ChannelIOSelector.isBooted()) {
            this.setVisibility(0);
            this.setLauncherStyle();
            if (ChannelIOSelector.shouldShowDefaultLauncherOnInit()) {
                this.showLauncherButton();
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    private void setLauncherStyle() {
        this.fab.setColorNormal(ColorSelector.getBackgroundColor());
        this.fab.setColorPressed(Utils.addBlackMask(ColorSelector.getBackgroundColor()));
        this.fab.setColorRipple(-1);
        this.fab.setImageResource(ColorSelector.getTextColor() == -16777216 ? R.drawable.ch_plugin_balloon_black : R.drawable.ch_plugin_balloon_white);
    }

    private void showLauncherButton() {
        if (ChannelIOSelector.isBooted()) {
            this.refreshCount();
            this.fabLayout.setVisibility(0);
        }
    }

    private void hideLauncherButton() {
        this.fabLayout.setVisibility(8);
    }

    public void refreshCount() {
        this.setBadge(CounterSelector.getTotalCounter());
    }

    private void setBadge(int count) {
        if (count <= 0) {
            this.badge.setVisibility(8);
        } else {
            this.badge.setVisibility(0);
            this.badge.setText(Utils.getCount(count, true));
        }
    }

    private void shutdown() {
        this.setVisibility(8);
        this.hideLauncherButton();
    }

    private void showPush(ProfileEntity person, String message, @Nullable UserChat userChat) {
        this.userChat = userChat;
        if (userChat != null) {
            if (userChat.isStateCompleted()) {
                this.avatarLayout.setVisibility(8);
                this.reviewAvatar.setVisibility(0);
                this.pushName.setTextByKey("ch.review.title.preview");
                this.pushMessage.setTextByKey("ch.review.require.preview");
            } else {
                this.reviewAvatar.setVisibility(8);
                this.avatarLayout.setVisibility(0);
                this.avatarLayout.set(person);
                this.avatarLayout.setTextSize(14);
                if (person != null && person.getName() != null) {
                    this.pushName.setText(person.getName());
                } else {
                    this.pushName.setTextByKey("ch.unknown");
                }
                if (MessageParser.get() != null) {
                    this.pushMessage.setText((CharSequence)MessageParser.get().parse(message));
                } else {
                    this.pushMessage.setText(message);
                }
            }
            this.pushLayout.setVisibility(0);
            this.pushLayout.startAnimation(this.pushAnimation);
            if (PrefSupervisor.isEnabledPushAlarm(this.context)) {
                AlarmCenter.alarm(this.context);
            }
        }
    }

    private void hidePush() {
        this.userChat = null;
        this.pushLayout.clearAnimation();
        this.pushLayout.setVisibility(8);
    }
}

