/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.FormMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonView;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TextMessageHolder;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.Utils;

public class FormMessageHolder
extends TextMessageHolder {
    private Context context;
    private LinearLayout extraMessageContentLayout;
    private FormButtonLayout formButtonLayout;
    @Nullable
    private OnFormMessageClickListener onClickListener;

    public static FormMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnFormMessageClickListener onClickListener) {
        return new FormMessageHolder(FormMessageHolder.getItemView(parent, messageType), onClickListener);
    }

    public FormMessageHolder(View itemView, @Nullable OnFormMessageClickListener onClickListener) {
        super(itemView, MessageType.FORM_MESSAGE);
        this.context = itemView.getContext();
        this.onClickListener = onClickListener;
        this.extraMessageContentLayout = (LinearLayout)itemView.findViewById(R.id.ch_message_content_extra);
        this.formButtonLayout = (FormButtonLayout)itemView.findViewById(R.id.ch_layout_form_button);
    }

    public void bind(ChatMessageItem chatItem, boolean isLastMessage, boolean isConnected) {
        super.bind(chatItem, isConnected);
        FormMessageItem formMessageItem = new FormMessageItem(chatItem.getMessage());
        if (!isLastMessage || !ListUtils.hasItems(formMessageItem.getActionInputs())) {
            this.extraMessageContentLayout.setVisibility(8);
        } else {
            this.extraMessageContentLayout.setVisibility(0);
            this.formButtonLayout.removeAllViews();
            this.formButtonLayout.refresh();
            this.formButtonLayout.setWidth(this.getButtonLayoutWidth(this.context));
            for (ActionInput actionInput : formMessageItem.getActionInputs()) {
                this.addFormButton(actionInput);
            }
        }
    }

    private void addFormButton(ActionInput actionInput) {
        FormButtonView formButtonView = new FormButtonView(this.context, actionInput, this.onClickListener);
        this.formButtonLayout.add((View)formButtonView);
    }

    private int getButtonLayoutWidth(Context context) {
        int windowWidth = Utils.getWindowSize((Context)context).x;
        int leftPadding = (int)Utils.dpToPx(context, 110.0f);
        int rightPadding = (int)Utils.dpToPx(context, 10.0f);
        return windowWidth - (leftPadding + rightPadding);
    }
}

