package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.event.LanguageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;

/**
 * Created by mika on 2016. 3. 9..
 */
public class WatchedEditText extends AppCompatEditText {

  private Context context;

  @Nullable
  private Button button;
  @Nullable
  private EditTextChangedListener listener;

  private Subscription subscription;

  @Nullable
  private String hintTextKey;

  private boolean block = false;
  private int activeColor, deactiveColor;

  public WatchedEditText(Context context) {
    super(context);
    init(context, null);
  }

  public WatchedEditText(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public WatchedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;
    subscribe();
    setTypeArray(attrs);
  }

  private void setTypeArray(@Nullable AttributeSet attrs) {
    if (attrs != null) {
      TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
      hintTextKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_hint_key);
      setHintByKey(hintTextKey);
    }
  }

  private void subscribe() {
    subscription = RxBus.observable()
        .onBackpressureBuffer()
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new Action1<Object>() {
          @Override
          public void call(Object o) {
            onReceiveEvent(o);
          }
        });
  }

  private void onReceiveEvent(Object object) {
    if (object instanceof LanguageBus && hintTextKey != null) {
      super.setHint(ResUtils.getString(context, hintTextKey));
    }
  }

  public void setHintByKey(@Nullable String key) {
    if (hintTextKey != null) {
      this.hintTextKey = key;
      super.setHint(ResUtils.getString(context, key));
    }
  }

  public void setWatchedTextChangedListener(EditTextChangedListener listener) {
    this.listener = listener;
    this.listener.onWatchedTextChanged(this.getText().toString());
  }

  public void setHandledButton(Button button, int activeColor, int deactiveColor) {
    this.button = button;
    this.activeColor = activeColor;
    this.deactiveColor = deactiveColor;

    setButtonStyle(getString());
  }

  @Override
  protected void onSelectionChanged(int start, int end) {
    super.onSelectionChanged(start, end);
  }

  @Override
  protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
    super.onTextChanged(text, start, lengthBefore, lengthAfter);
    if (listener != null && !block) {
      listener.onWatchedTextChanged(text.toString());
    }
    setButtonStyle(text.toString());
  }

  private void setButtonStyle(String text) {
    if (button != null) {
      if ("".equals(StringUtils.stripEnd(text, null))) {
        button.setEnabled(false);
        button.setTextColor(deactiveColor);
      } else {
        button.setEnabled(true);
        button.setTextColor(activeColor);
      }
    }
  }

  public void setTextWithBlock(String text) {
    this.block = true;
    setText(text);
  }

  public void setBlock(boolean block) {
    this.block = block;
  }

  public String getString() {
    return getText().toString();
  }

  public boolean isEmpty() {
    return TextUtils.isEmpty(getString());
  }

  @Override
  protected void onDetachedFromWindow() {
    if (!subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    super.onDetachedFromWindow();
  }
}
