package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.text.method.LinkMovementMethod;
import android.text.util.Linkify;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

/**
 * Created by mika on 2018. 6. 22..
 */

public class WelcomeMessageHolder extends TextMessageHolder {

  public static WelcomeMessageHolder newInstance(ViewGroup parent) {
    return new WelcomeMessageHolder(getItemView(parent, MessageType.WELCOME_MESSAGE));
  }

  public WelcomeMessageHolder(View itemView) {
    super(itemView, MessageType.WELCOME_MESSAGE);
  }

  public void bind(WelcomeMessageItem item) {
    super.bind(item.getMessage(), MessageType.WELCOME_MESSAGE, false);

    if (managerMessageTextLayout != null &&
        managerMessageText != null &&
        managerMessageHeadTop != null &&
        managerMessageContextTop != null) {
      managerMessageText.setLinksClickable(true);
      managerMessageText.setAutoLinkMask(Linkify.WEB_URLS);

      if (item.getMessage().getFormattedSpanMessage() != null) {
        managerMessageText.setText(item.getMessage().getFormattedSpanMessage());
        managerMessageText.setMovementMethod(LinkMovementMethod.getInstance());
      } else {
        managerMessageText.setText("");
      }

      managerMessageTextLayout.setVisibility(View.VISIBLE);
      managerMessageHeadTop.setVisibility(View.VISIBLE);
      managerMessageContextTop.setVisibility(View.GONE);
    }
  }
}
