package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;

/**
 * Created by mika on 2017. 3. 2..
 */
public class SendingMessageHolder extends BaseMessageHolder implements View.OnClickListener {


  protected View root;

  protected View resendLocalContentButton;

  protected View localTextLayout;
  protected View localTextHeadLayout;
  protected View localTextHeadBackground;
  protected View localTextContentLayout;
  protected View localTextContentBackground;
  protected CHTextView localMessageText;

  protected View localImageLayout;
  protected MaskableFrameLayout localImageLoadingLayout;
  protected ImageView imagePlaceholder;
  protected ImageView imageLoading;
  protected View localImageProgressView, localImageUploadFailedView;

  private Context context;

  @Nullable
  private OnSendingMessageClickListener listener;
  @Nullable
  private SendingMessageItem item;

  public static SendingMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnSendingMessageClickListener listener) {
    return new SendingMessageHolder(getItemView(parent, messageType), messageType, listener);
  }

  public SendingMessageHolder(
      View itemView,
      MessageType messageType,
      @Nullable OnSendingMessageClickListener listener) {
    super(itemView, messageType);

    this.context = itemView.getContext();
    this.listener = listener;

    root = itemView.findViewById(R.id.ch_message_content_loading);

    localMessageText = itemView.findViewById(R.id.ch_text_local_message);
    localTextLayout = itemView.findViewById(R.id.ch_layout_local_message_text);
    localTextHeadLayout = itemView.findViewById(R.id.ch_layout_local_message_head);
    localTextHeadBackground = itemView.findViewById(R.id.ch_view_local_message_head_top);
    localTextContentLayout = itemView.findViewById(R.id.ch_layout_local_message_content);
    localTextContentBackground = itemView.findViewById(R.id.ch_view_local_message_content_top);

    imagePlaceholder = itemView.findViewById(R.id.image_placeholder);
    imageLoading = itemView.findViewById(R.id.image_loading);

    localImageLayout = itemView.findViewById(R.id.ch_layout_local_message_image_content);
    localImageLoadingLayout = itemView.findViewById(R.id.ch_layout_local_message_image);
    localImageProgressView = itemView.findViewById(R.id.progress_upload);
    localImageUploadFailedView = itemView.findViewById(R.id.image_upload_failed);

    resendLocalContentButton = itemView.findViewById(R.id.ch_button_local_message_resend);
    resendLocalContentButton.setOnClickListener(this);
  }

  public void bind(SendingMessageItem item, boolean isConnected) {
    super.bind(null, item.getType(), true);
    this.item = item;
    root.setVisibility(View.VISIBLE);
    localImageLayout.setVisibility(View.GONE);
    localTextLayout.setVisibility(View.GONE);
    resendLocalContentButton.setVisibility(UIUtils.getVisible(!item.isSending(), true));

    if (guestMessageTextLayout != null) {
      guestMessageTextLayout.setVisibility(View.GONE);
    }
    if (guestMessageTime != null) {
      guestMessageTime.setVisibility(View.GONE);
    }

    localTextHeadLayout.setVisibility(UIUtils.getVisible(!isConnected, true));
    localTextContentLayout.setVisibility(UIUtils.getVisible(isConnected, true));

    if (item.isImage()) {
      setLocalImageMessage(item);
    } else {
      setLocalTextMessage(item);
    }
  }

  private void setLocalImageMessage(SendingMessageItem item) {
    if (item.getString() != null) {
      String imagePath = item.getString();
      Point previewImageSize = Utils.resizeImage(context, Utils.getImageArea(imagePath));
      Resizer.size(localImageLayout, previewImageSize.x, previewImageSize.y);

      Glide.with(itemView.getContext())
          .load(imagePath)
          .asBitmap()
          .override(previewImageSize.x, previewImageSize.y)
          .dontAnimate()
          .centerCrop()
          .into(imageLoading);

      imagePlaceholder.setVisibility(View.GONE);

      localImageLayout.setVisibility(View.VISIBLE);
      localImageLoadingLayout.setVisibility(View.VISIBLE);
      localImageProgressView.setVisibility(UIUtils.getVisible(item.isSending(), true));
      localImageUploadFailedView.setVisibility(UIUtils.getVisible(!item.isSending(), true));
    }
  }

  private void setLocalTextMessage(SendingMessageItem item) {
    CharSequence localMessage = MessageParser.get() != null
        ? MessageParser.get().parse(item.getMessage())
        : item.getMessage();

    localTextLayout.setVisibility(View.VISIBLE);
    localMessageText.setText(localMessage);
    localMessageText.setTextColor(ColorSelector.getTextColor());
    localMessageText.setBackgroundColor(ColorSelector.getBackgroundColor());
    localTextHeadBackground.setBackgroundColor(ColorSelector.getBackgroundColor());
    localTextContentBackground.setBackgroundColor(ColorSelector.getBackgroundColor());
  }

  @Override
  public void onClick(View v) {
    if (listener != null && item != null) {
      listener.requestResendClicked(item);
    }
  }
}
