/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListAdapter;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatPresenter;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.AlertDialogListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.WaterMarkLayout;

public class UserChatListActivity
extends BaseActivity
implements View.OnClickListener,
UserChatContract.View {
    private UserChatContract.Presenter presenter;
    private View emptyLayout;
    private View reconnectLayout;
    private RecyclerView chatList;
    private WaterMarkLayout waterMarkLayout;
    private LinearLayout rootView;
    private FloatingActionButton fab;
    private LinearLayoutManager layoutManager;
    private UserChatListAdapter adapter;
    private String tempChatId;
    private boolean showingChat = false;
    private boolean isRefreshUserChat = false;
    private boolean isPushClickedChat = false;
    private Channel channel;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_user_chat_list);
        if (this.getIntent() != null) {
            this.tempChatId = this.getIntent().getStringExtra("chatId");
            this.isPushClickedChat = this.getIntent().getBooleanExtra("push_click", false);
        }
        this.rootView = (LinearLayout)this.findViewById(R.id.root_view);
        this.emptyLayout = this.findViewById(R.id.layout_empty);
        this.reconnectLayout = this.findViewById(R.id.layout_reconnect);
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.fab.setOnClickListener(this);
        this.fab.hide(false);
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.SETTINGS, BigBar.MenuPosition.LEFT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).build();
        this.adapter = new UserChatListAdapter();
        this.presenter = new UserChatPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setAdapterModel(this.adapter);
        this.channel = ChannelStore.getChannel();
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.chatList = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.chatList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.chatList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.chatList.setItemAnimator(null);
        this.chatList.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.waterMarkLayout = (WaterMarkLayout)this.findViewById(R.id.chatlist_layout_water_mark);
        this.setWaterMarkLayout(this.channel);
        if (SocketManager.isError()) {
            this.setRefreshVisibility(true);
            this.setReconnectVisibility(true);
        }
        this.setStyle();
        this.presenter.getUserChats();
    }

    private void setWaterMarkLayout(final Channel channelInfo) {
        if (channelInfo != null && channelInfo.isTrial().booleanValue()) {
            this.waterMarkLayout.setVisibility(0);
            this.waterMarkLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Executor.goWeb(UserChatListActivity.this.getBaseContext(), String.format("https://channel.io/%s/?utm_source=%s&utm_medium=plugin&utm_campaign=android&utm_content=%s&utm_channel_id=%s", PrefSupervisor.getPluginLanguage((Context)UserChatListActivity.this), "plugin_watermark", channelInfo.getName(), channelInfo.getId()));
                }
            });
            this.chatList.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, -1, this.chatList){

                @Override
                public void scrolledInList() {
                    UserChatListActivity.this.waterMarkLayout.setVisibility(8);
                }

                @Override
                public void scrollAttachedToBottom() {
                    UserChatListActivity.this.waterMarkLayout.setVisibility(0);
                }

                @Override
                public void refresh() {
                }
            });
        } else {
            this.waterMarkLayout.setVisibility(8);
            this.chatList.setPadding(0, 0, 0, 0);
        }
        if (!this.animated) {
            this.overridePendingTransition(R.anim.ch_plugin_idle, R.anim.ch_plugin_idle);
        }
    }

    @Override
    protected void onDestroy() {
        if (this.presenter != null) {
            this.presenter.release();
        }
        super.onDestroy();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.rootView.setVisibility(0);
        block0 : switch (requestCode) {
            case 3002: {
                if (resultCode != 23) break;
                this.refreshUserChat();
                break;
            }
            case 21: {
                this.showingChat = false;
                switch (resultCode) {
                    case 22: {
                        this.startChat(null, this.presenter.getChatCount(null), false);
                        break block0;
                    }
                    case 23: {
                        this.refreshUserChat();
                        break block0;
                    }
                    case 24: {
                        this.finish();
                    }
                }
            }
        }
    }

    protected void onStart() {
        this.presenter.setRunningChatId(null);
        ChannelPushManager.sendTokenToChannelIO(ChannelIO.getAppContext());
        super.onStart();
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.fab) {
            this.startChat(null, this.presenter.getChatCount(null), this.adapter.getItemCount() == 0);
        }
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case REFRESH: {
                this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.HIDDEN);
                this.presenter.refresh();
                break;
            }
            case SETTINGS: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).startActivityForResult(3002);
            }
        }
        super.optionClicked(actionType);
    }

    private void setStyle() {
        Plugin plugin = ChannelStore.getPlugin();
        if (this.channel == null || plugin == null) {
            this.finish();
        } else {
            this.setStatusBarColor(plugin.getBackgroundColor());
            this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
            this.getBigBar().setTitle(this.channel.getName());
            this.fab.setColorNormal(plugin.getBackgroundColor());
            this.fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
            this.fab.setColorRipple(-1);
            this.fab.setImageResource(plugin.getTextColor() == -16777216 ? R.drawable.ch_plugin_ic_add_black_24dp : R.drawable.ch_plugin_ic_add_white_24dp);
            this.fab.attachToRecyclerView(this.chatList);
        }
    }

    private void refreshUserChat() {
        this.isRefreshUserChat = true;
        this.presenter.setInit(true);
        this.presenter.getUserChats();
    }

    @Override
    public void userChatsFetched(UserChatsWrapper userChatsWrapper, boolean init) {
        this.getBigBar().setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.VISIBLE);
        this.fab.show();
        if (this.tempChatId != null) {
            this.startChat(this.tempChatId, this.presenter.getChatCount(this.tempChatId), this.isPushClickedChat);
            this.tempChatId = null;
        } else {
            if (this.adapter.getItemCount() <= 1 && !this.isRefreshUserChat && !this.showingChat && init) {
                if (this.adapter.getItemCount() == 0) {
                    this.startChat(null, 0, true);
                } else {
                    String chatId = this.adapter.getChatId(0);
                    this.startChat(chatId, 0, true);
                }
            } else {
                this.rootView.setVisibility(0);
            }
            this.isRefreshUserChat = false;
        }
        this.setViewVisibility();
    }

    @Override
    public void startChat(String chatId, int chatCount, boolean isFirstChat) {
        this.showingChat = true;
        IntentUtils.setNextActivity((Context)this, ChatActivity.class).putExtra("chatId", chatId).putExtra("chatCount", chatCount).putExtra("firstChat", isFirstChat).putExtra("animated", this.animated).startActivityForResult(21);
    }

    @Override
    public void setRefreshVisibility(boolean showRefresh) {
        this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, showRefresh ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
    }

    @Override
    public void setReconnectVisibility(boolean show) {
        this.reconnectLayout.setVisibility(UIUtils.getVisible(show, true));
    }

    @Override
    public void checkUserChat(boolean hasCheckedChat) {
        this.getBigBar().setMenuState(MenuButton.ActionType.DELETE, hasCheckedChat ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.DISABLED);
    }

    @Override
    public void deleteChat(final String chatId) {
        UIUtils.showAlertDialog((Context)this, ResUtils.getString((Context)this, "ch.chat.delete_description"), true, new AlertDialogListener(){

            @Override
            public void onPositive() {
                UserChatListActivity.this.presenter.requestRemoveChat(chatId);
            }
        });
    }

    @Override
    public void completeRemoveChat() {
        this.hideProgress();
        this.setViewVisibility();
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        this.presenter.receiveData(channelModel, upsert);
        this.setViewVisibility();
    }

    private void setViewVisibility() {
        this.emptyLayout.setVisibility(UIUtils.getVisible(!this.hasUserChat(), true));
        this.chatList.setVisibility(UIUtils.getVisible(this.hasUserChat(), true));
    }

    private boolean hasUserChat() {
        return this.adapter.getItemCount() > 0;
    }

    @Override
    @AnimRes
    protected int getEnterAnimOfCreate() {
        return R.anim.ch_plugin_slide_in_bottom;
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        return R.anim.ch_plugin_slide_out_bottom;
    }
}

