/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.ChatCompltedFragment;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.PreviewFragment;
import com.zoyi.channel.plugin.android.activity.chat.TopNavFragment;
import com.zoyi.channel.plugin.android.activity.chat.TypingManager;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.LinkableMessageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TopNavBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract;
import com.zoyi.channel.plugin.android.presenter.chat.ChatPresenter;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.handler.BackgroundToucher;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.ChatRecyclerView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.channel.plugin.android.view.layout.WaterMarkLayout;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import java.util.List;

public class ChatActivity
extends BaseActivity
implements ChatContract.View,
EditTextChangedListener,
View.OnClickListener,
TopNavFragment.OnChatTopNavListener {
    private static final int DELAY_EXPAND_COLLAPSE = 512;
    private TopNavFragment topNavFragment;
    private ChatRecyclerView chatList;
    private WatchedEditText editChat;
    private ImageButton imageSend;
    private View layoutInput;
    private PreviewFragment previewFragment;
    private ChatCompltedFragment compltedFragment;
    private WaterMarkLayout waterMarkLayout;
    private CHTextView disabledInputText;
    private LinearLayoutManager layoutManager;
    private TypingManager typingManager;
    private ChatContract.Presenter presenter;
    private ChatAdapter adapter;
    private int currentPosition;
    private Subscription subscription;
    private Channel channel;
    private int enterAnimInCreate;
    private int existAnimInFinish;
    boolean isFirstChat;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_chat);
        String chatId = null;
        int chatCount = 0;
        this.isFirstChat = false;
        if (this.getIntent() != null) {
            chatId = this.getIntent().getStringExtra("chatId");
            chatCount = this.getIntent().getIntExtra("chatCount", 0);
            this.isFirstChat = this.getIntent().getBooleanExtra("firstChat", false);
        }
        this.initBigBar(chatCount, this.isFirstChat);
        this.setActivityAnim(this.isFirstChat);
        FragmentManager fm = this.getSupportFragmentManager();
        this.channel = ChannelStore.getChannel();
        this.topNavFragment = (TopNavFragment)fm.findFragmentById(R.id.f_chat_top_nav);
        this.topNavFragment.setOnChatTopNavListener(this);
        this.presenter = new ChatPresenter((Context)this);
        this.adapter = new ChatAdapter(TextUtils.isEmpty((CharSequence)chatId));
        this.presenter.setView(this);
        this.presenter.setAdapterModel(this.adapter);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setChatId(chatId);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.layoutManager.setStackFromEnd(true);
        this.chatList = (ChatRecyclerView)this.findViewById(R.id.recycler_chat);
        this.chatList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.chatList.setAdapter(this.adapter);
        this.chatList.setItemAnimator(null);
        this.chatList.getRecycledViewPool().setMaxRecycledViews(MessageType.VERIFY.toInt(), 1);
        this.chatList.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (bottom < oldBottom) {
                    ChatActivity.this.collapseTopNav(true);
                    if (ChatActivity.this.currentPosition == ChatActivity.this.adapter.getItemCount() - 1) {
                        ChatActivity.this.chatList.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                ChatActivity.this.layoutManager.scrollToPosition(ChatActivity.this.currentPosition);
                            }
                        }, 100L);
                    }
                }
            }
        });
        this.chatList.setTopNavFragment(this.topNavFragment);
        this.chatList.addOnScrollListener(new InfiniteScrollListener(this.layoutManager, 1, this.chatList){

            @Override
            public void scrolledInList() {
            }

            @Override
            public void scrollAttachedToBottom() {
                ChatActivity.this.previewFragment.hide();
            }

            @Override
            public void refresh() {
                ChatActivity.this.presenter.fetchBackwardMessages();
            }
        });
        this.waterMarkLayout = (WaterMarkLayout)this.findViewById(R.id.chat_layout_water_mark);
        this.setWaterMarkLayout(this.channel);
        this.findViewById(R.id.button_attach).setOnClickListener((View.OnClickListener)this);
        this.imageSend = (ImageButton)this.findViewById(R.id.iv_chat_send);
        this.imageSend.setOnClickListener((View.OnClickListener)this);
        this.editChat = (WatchedEditText)this.findViewById(R.id.edit_chat);
        this.editChat.setWatchedTextChangedListener(this);
        this.editChat.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                ChatActivity.this.adapter.setChatEditTextFocus(hasFocus);
            }
        });
        this.editChat.setText(PrefSupervisor.getStoredMessage((Context)this));
        PrefSupervisor.clearStoredMessage((Context)this);
        this.layoutInput = this.findViewById(R.id.layout_input);
        this.disabledInputText = (CHTextView)this.findViewById(R.id.text_disabled_input);
        this.setDisabledInputBoxVisibility(this.channel, false);
        this.previewFragment = (PreviewFragment)fm.findFragmentById(R.id.f_chat_preview);
        this.compltedFragment = (ChatCompltedFragment)fm.findFragmentById(R.id.f_chat_completed);
        BackgroundToucher.makeKeyboardEvent(this, this.chatList, (EditText)this.editChat);
        this.setStyle();
        this.presenter.requestPreloadData(chatId);
        this.typingManager = new TypingManager(chatId, "UserChat", this.editChat);
        if (SocketManager.isError()) {
            this.setReconnectVisibility(true);
        }
        this.subscribe();
        if (this.animated) {
            this.overridePendingTransition(this.enterAnimInCreate, R.anim.ch_plugin_idle);
        } else {
            this.overridePendingTransition(R.anim.ch_plugin_idle, R.anim.ch_plugin_idle);
        }
    }

    private void setWaterMarkLayout(final Channel channelInfo) {
        if (channelInfo != null && channelInfo.isTrial().booleanValue()) {
            this.waterMarkLayout.setVisibility(0);
            this.waterMarkLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Executor.goWeb(ChatActivity.this.getBaseContext(), String.format("https://channel.io/%s/?utm_source=%s&utm_medium=plugin&utm_campaign=android&utm_content=%s&utm_channel_id=%s", PrefSupervisor.getPluginLanguage((Context)ChatActivity.this), "plugin_watermark", channelInfo.getName(), channelInfo.getId()));
                }
            });
            this.chatList.addOnScrollListener(new InfiniteScrollListener(this.layoutManager, 1, this.chatList){

                @Override
                public void scrolledInList() {
                    ChatActivity.this.waterMarkLayout.setVisibility(8);
                }

                @Override
                public void scrollAttachedToBottom() {
                    ChatActivity.this.waterMarkLayout.setVisibility(0);
                }

                @Override
                public void refresh() {
                }
            });
        } else {
            this.waterMarkLayout.setVisibility(8);
            this.chatList.setPadding(0, 0, 0, 0);
        }
    }

    @Override
    protected void onDestroy() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        if (this.presenter != null) {
            this.presenter.release();
        }
        super.onDestroy();
    }

    @Override
    public void finish() {
        if (this.presenter != null && this.presenter.getChatId() != null) {
            this.presenter.leaveChat();
        }
        super.finish();
    }

    private void initBigBar(int chatCount, boolean isFirstChat) {
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.SETTINGS, BigBar.MenuPosition.LEFT, isFirstChat ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT, isFirstChat ? MenuButton.MenuState.HIDDEN : MenuButton.MenuState.VISIBLE).addText(BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).build();
        this.getBigBar().setText(chatCount);
    }

    private void setActivityAnim(boolean isFirstChat) {
        if (isFirstChat) {
            this.enterAnimInCreate = R.anim.ch_plugin_slide_in_bottom;
            this.existAnimInFinish = R.anim.ch_plugin_slide_out_bottom;
        } else {
            this.enterAnimInCreate = R.anim.ch_plugin_slide_in_right;
            this.existAnimInFinish = R.anim.ch_plugin_slide_out_right;
        }
    }

    private void setStyle() {
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            this.adapter.setColor(plugin.getBackgroundColor(), plugin.getTextColor());
            this.setStatusBarColor(plugin.getBackgroundColor());
            this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
            this.getBigBar().setImageLeftOfTitle(R.drawable.ch_plugin_normal_w);
            this.getBigBar().getImageLeftOfTitle().setVisibility(4);
            this.getBigBar().setImageRightOfTitle(plugin.getTextColor() == -1 ? R.drawable.ch_plugin_dropdown_arrow_down : R.drawable.ch_plugin_dropdown_arrow_down_b);
        }
        if (this.channel != null) {
            this.getBigBar().setTitle(this.channel.getName());
        }
    }

    private void setDisabledInputBoxVisibility(Channel channel, boolean isSocketEvent) {
        if (channel != null) {
            if (isSocketEvent) {
                if (channel.isWorking() || "active".equals(channel.getAwayOption())) {
                    this.setDisabledInputBoxVisibility(false);
                }
            } else if (!channel.isWorking() && "disabled".equals(channel.getAwayOption())) {
                this.setDisabledInputBoxVisibility(true);
            } else {
                this.setDisabledInputBoxVisibility(false);
            }
        } else {
            this.setDisabledInputBoxVisibility(false);
        }
    }

    private void setDisabledInputBoxVisibility(boolean isDisabled) {
        this.disabledInputText.setVisibility(UIUtils.getVisible(isDisabled, true));
        this.layoutInput.setVisibility(UIUtils.getVisible(!isDisabled, true));
    }

    private void subscribe() {
        this.subscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (o != null && o instanceof TopNavBus.Change) {
                    ChatActivity.this.changeBigBar(((TopNavBus.Change)o).expand);
                }
            }
        });
    }

    private void changeBigBar(boolean expand) {
        Plugin plugin = ChannelStore.getPlugin();
        UserChat userChat = this.presenter.getUserChat();
        BigBar bigBar = this.getBigBar();
        bigBar.getImageRightOfTitle().setRotation(expand ? -180.0f : 0.0f);
        if (userChat == null || userChat.isStateReady() || userChat.isStateOpen()) {
            bigBar.setImageLeftOfTitle(ChatResponseManager.getResponseSymbol(plugin, this.channel));
            bigBar.setTitle(this.channel == null ? ResUtils.getString((Context)this, "ch.unknown") : this.channel.getName());
            bigBar.setSubTitleByKey(ChatResponseManager.getShortResponseDescriptionKey(this.channel)).setSubTitleVisibility(!expand);
        } else {
            ProfileEntity entity = ChatDataDictionary.getInstance().getProfile(userChat.getHostType(), userChat.getHostId());
            bigBar.setImageLeftOfTitle(ChatResponseManager.getManagerOnlineSymbol(plugin, entity));
            bigBar.setTitle(entity == null ? "" : entity.getName());
            bigBar.setSubTitleVisibility(false);
        }
        if (expand) {
            bigBar.getImageLeftOfTitle().setVisibility(4);
        }
    }

    @Override
    public void onLoadUserChat(UserChat userChat, boolean create) {
        ChatDataDictionary dictionary = ChatDataDictionary.getInstance();
        if (userChat != null) {
            this.typingManager.setChatId(userChat.getId());
        }
        if (userChat == null || userChat.isStateReady() || userChat.isStateOpen()) {
            this.topNavFragment.set(dictionary.getFollingManagers());
            if (userChat == null) {
                this.expandTopNav(false);
            } else {
                this.collapseTopNav(true);
                this.getBigBar().setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.VISIBLE);
                this.getBigBar().setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.HIDDEN);
            }
        } else {
            ProfileEntity profileEntity = dictionary.getProfile(userChat.getHostType(), userChat.getHostId());
            if (profileEntity == null) {
                profileEntity = UserChatListDataDictionary.getInstance().getProfile(userChat.getHostType(), userChat.getHostId());
            }
            this.topNavFragment.set(profileEntity);
            this.collapseTopNav(true);
            this.getBigBar().setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.VISIBLE);
            this.getBigBar().setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.HIDDEN);
        }
        this.getBigBar().setOnClickListener(this);
    }

    @Override
    public void updateBackwardId(String backwardId) {
        this.chatList.setBackwardId(backwardId);
    }

    @Override
    public void setInputLayoutVisibility() {
        if (this.presenter.isStateCompleted()) {
            Keyboard.close((Context)this, (View)this.editChat);
            this.compltedFragment.show(this.editChat.getText().toString().trim());
            this.layoutInput.setVisibility(8);
            this.disabledInputText.setVisibility(8);
        } else {
            this.compltedFragment.hide();
            this.layoutInput.setVisibility(0);
            this.disabledInputText.setVisibility(8);
        }
    }

    @Override
    public boolean isMovableToBottomPosition() {
        int lastPosition = this.layoutManager.findLastVisibleItemPosition();
        return lastPosition <= this.adapter.getItemCount() - 2 && lastPosition >= this.adapter.getItemCount() - 4;
    }

    @Override
    public boolean isBottomPosition() {
        return this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.adapter.getItemCount() - 2;
    }

    @Override
    public void scrollToPostion(int position) {
        this.layoutManager.scrollToPosition(position);
    }

    @Override
    public void scrollToBottom(boolean force) {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() == this.adapter.getItemCount() - 2 || force) {
            this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.sendImageFiles(data.getStringArrayListExtra("PHOTO_INTENT_KEY"));
                this.collapseTopNav(true);
                break;
            }
            case 3001: {
                PhotoAlbumStorage.getInstance().release();
                break;
            }
            case 3002: {
                if (resultCode != 23) break;
                this.setResult(23);
            }
        }
    }

    @Override
    protected void receiveRxEvent(Object o) {
        super.receiveRxEvent(o);
        if (o instanceof LinkableMessageBus) {
            LinkableMessageBus linkable = (LinkableMessageBus)o;
            this.onClickLinkableMessage(linkable.getMessage(), linkable.getLinkType());
        }
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        this.presenter.receiveData(channelModel, upsert);
    }

    @Override
    public void receiveChatCounter(int count) {
        if (count > 0) {
            this.getBigBar().setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.VISIBLE);
            this.getBigBar().setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.HIDDEN);
        }
        this.getBigBar().setText(count);
    }

    @Override
    public void receiveTyping(Typing typing) {
        if (typing != null && typing.isOther() && typing.isSameChat(this.presenter.getChatId(), "UserChat")) {
            this.typingManager.addTTLTimer(typing);
            this.presenter.receiveTyping(typing);
        }
    }

    @Override
    public void receiveLanguageEvent() {
        this.presenter.receiveLanguageEvent();
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case REFRESH: {
                this.presenter.refresh();
                break;
            }
            case SETTINGS: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).startActivityForResult(3002);
                break;
            }
            case BACK: {
                this.existAnimInFinish = R.anim.ch_plugin_slide_out_right;
                this.finish();
                break;
            }
            case EXIT: {
                this.existAnimInFinish = R.anim.ch_plugin_slide_out_bottom;
                this.setResult(24);
                this.finish();
            }
        }
    }

    @Override
    public void setRefreshVisibility(boolean showRefresh) {
        this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, showRefresh ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
    }

    @Override
    public void setReconnectVisibility(boolean show) {
        this.topNavFragment.setReconnectVisibility(show);
    }

    @Override
    public void setChannel(Channel channel) {
        this.changeBigBar(this.topNavFragment.isExpand());
        this.setDisabledInputBoxVisibility(channel, true);
        this.topNavFragment.setChannel(channel);
        if (this.topNavFragment.isExpand()) {
            this.chatList.setTranslationY(this.topNavFragment.getExpectHeight());
        }
    }

    @Override
    public void changeBigBar() {
        this.changeBigBar(this.topNavFragment.isExpand());
    }

    @Override
    public void processNewMessage(ProfileEntity profileEntity, Message message) {
        if (profileEntity == null || message == null || message.getLog() != null) {
            return;
        }
        if (this.layoutManager.canScrollVertically() && !this.isBottomPosition()) {
            this.previewFragment.show(profileEntity);
        }
    }

    @Override
    public void setProfileEntity(ProfileEntity profileEntity) {
        this.topNavFragment.set(profileEntity);
        if (this.topNavFragment.isExpand()) {
            this.chatList.setTranslationY(this.topNavFragment.getExpectHeight());
        }
    }

    @Override
    public void onRemovedChat() {
        this.finish();
    }

    @Override
    public void onWatchedTextChanged(String s) {
        this.imageSend.setEnabled(!TextUtils.isEmpty((CharSequence)s.trim()));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.button_attach) {
            this.hideKeyboard((EditText)this.editChat);
            IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
        }
        if (id2 == R.id.iv_chat_send) {
            this.presenter.sendTextMessage(this.editChat.getString());
            this.editChat.setText("");
            this.topNavFragment.collapse();
        }
        if (id2 == R.id.big_bar) {
            if (this.chatList.isScrolling()) {
                return;
            }
            if (this.topNavFragment.isExpand()) {
                this.collapseTopNav(true);
            } else {
                this.expandTopNav(true);
            }
        }
    }

    private void collapseTopNav(boolean immediately) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ChatActivity.this.topNavFragment.collapse();
                ChatActivity.this.chatList.setTranslationY(0.0f, true);
            }
        }, immediately ? 0L : 512L);
    }

    private void expandTopNav(boolean immediately) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                int topNavHeight = ChatActivity.this.topNavFragment.getExpectHeight();
                ChatActivity.this.hideKeyboard((EditText)ChatActivity.this.editChat);
                ChatActivity.this.topNavFragment.setTranslationY(-topNavHeight);
                ChatActivity.this.topNavFragment.expand();
                if (ChatActivity.this.chatList.canScrollVertically(-1)) {
                    ChatActivity.this.changeBigBar(true);
                } else {
                    ChatActivity.this.changeBigBar(topNavHeight > 0);
                }
            }
        }, immediately ? 0L : 512L);
    }

    @Override
    public void onClickTopNav() {
        if (this.chatList.isScrolling()) {
            return;
        }
        this.topNavFragment.collapse();
    }

    @Override
    public void onFileDownload(Message message) {
        File file = message.getFile();
        if (file.getType() != null && file.getType().startsWith("video")) {
            IntentUtils.setNextActivity((Context)this, VideoViewerActivity.class).putExtra("filename", file.getName()).putExtra("url", file.getUrl()).startActivity();
        } else {
            IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", file.getUrl()).putExtra("filename", file.getFilename()).putExtra("image", file.isImage()).startActivity();
        }
    }

    @Override
    public void onShowPhotoAlbum(File file) {
        IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("fileId", file.getId()).startActivityForResult(3001);
    }

    @Override
    public void onUrlClicked(String url) {
        boolean handle = false;
        List<ChannelPluginListener> listeners = ChannelIO.getChannelPluginListeners();
        if (listeners.isEmpty()) {
            IntentUtils.setUrl((Context)this, url).startActivity();
        } else {
            for (ChannelPluginListener listener : listeners) {
                handle = listener.onClickChatLink(url);
                if (handle) continue;
                IntentUtils.setUrl((Context)this, url).startActivity();
            }
        }
    }

    private void onClickLinkableMessage(String linkText, LinkType linkType) {
        switch (linkType) {
            case URL: {
                this.onUrlClicked(linkText);
                break;
            }
            case PHONE: {
                IntentUtils.setPhone((Context)this, linkText).startActivity();
                break;
            }
            case EMAIL: {
                IntentUtils.setEmail((Context)this, linkText).startActivity();
            }
        }
    }

    @Override
    public void onChangeProfileMessageFocus(boolean hasFocus) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.layoutInput.setBackground(ContextCompat.getDrawable((Context)this, (int)(hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg)));
        } else {
            this.layoutInput.setBackgroundDrawable(ContextCompat.getDrawable((Context)this, (int)(hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg)));
        }
    }

    public void onBackPressed() {
        if (this.isFirstChat) {
            this.setResult(24);
        }
        this.finish();
    }

    @Override
    public void requestFocusEditText() {
        this.editChat.requestFocus();
    }

    @Override
    public void sendingMessageClicked(final SendingMessageItem item) {
        final AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.retry_sending_message"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.resend(item);
            }
        }).setNegativeButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.delete"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.removeFailedItem(item);
            }
        }).setCancelable(true).create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface args) {
                int dark = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_dark);
                int cobalt = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_cobalt);
                dialog.getButton(-1).setTextColor(cobalt);
                dialog.getButton(-2).setTextColor(dark);
                dialog.getButton(-3).setTextColor(dark);
            }
        });
        dialog.show();
    }

    @Override
    @AnimRes
    protected int getEnterAnimOfCreate() {
        return this.enterAnimInCreate;
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        return this.existAnimInFinish;
    }
}

