/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.subjects.Subject;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BufferUntilSubscriber<T>
extends Subject<T, T> {
    final State<T> state;
    private boolean forward;
    static final Observer EMPTY_OBSERVER = new Observer(){

        public void onCompleted() {
        }

        public void onError(Throwable e) {
        }

        public void onNext(Object t) {
        }
    };

    public static <T> BufferUntilSubscriber<T> create() {
        State state = new State();
        return new BufferUntilSubscriber(state);
    }

    private BufferUntilSubscriber(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(Object v) {
        Object object = this.state.guard;
        synchronized (object) {
            this.state.buffer.add(v);
            if (this.state.get() != null && !this.state.emitting) {
                this.forward = true;
                this.state.emitting = true;
            }
        }
        if (this.forward) {
            Object o;
            while ((o = this.state.buffer.poll()) != null) {
                NotificationLite.accept((Observer)this.state.get(), o);
            }
        }
    }

    @Override
    public void onCompleted() {
        if (this.forward) {
            ((Observer)this.state.get()).onCompleted();
        } else {
            this.emit(NotificationLite.completed());
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.forward) {
            ((Observer)this.state.get()).onError(e);
        } else {
            this.emit(NotificationLite.error(e));
        }
    }

    @Override
    public void onNext(T t) {
        if (this.forward) {
            ((Observer)this.state.get()).onNext(t);
        } else {
            this.emit(NotificationLite.next(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasObservers() {
        Object object = this.state.guard;
        synchronized (object) {
            return this.state.get() != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(Subscriber<? super T> s) {
            if (this.state.casObserverRef(null, s)) {
                s.add(Subscriptions.create(new Action0(){

                    public void call() {
                        OnSubscribeAction.this.state.set(EMPTY_OBSERVER);
                    }
                }));
                boolean win = false;
                Object object = this.state.guard;
                synchronized (object) {
                    if (!this.state.emitting) {
                        this.state.emitting = true;
                        win = true;
                    }
                }
                if (win) {
                    while (true) {
                        Object o;
                        if ((o = this.state.buffer.poll()) != null) {
                            NotificationLite.accept((Observer)this.state.get(), o);
                            continue;
                        }
                        Object object2 = this.state.guard;
                        synchronized (object2) {
                            if (this.state.buffer.isEmpty()) {
                                this.state.emitting = false;
                                break;
                            }
                        }
                    }
                }
            } else {
                s.onError(new IllegalStateException("Only one subscriber allowed!"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class State<T>
    extends AtomicReference<Observer<? super T>> {
        private static final long serialVersionUID = 8026705089538090368L;
        final Object guard = new Object();
        boolean emitting;
        final ConcurrentLinkedQueue<Object> buffer = new ConcurrentLinkedQueue();

        State() {
        }

        boolean casObserverRef(Observer<? super T> expected, Observer<? super T> next) {
            return this.compareAndSet(expected, next);
        }
    }
}

