/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.widget.CompoundButton;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.settings.setting_language.SettingLanguageActivity;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

public class SettingsActivity
extends BaseActivity
implements CompoundButton.OnCheckedChangeListener,
View.OnClickListener {
    private CHTextView languageSettingText;
    private Channel channel;
    private boolean completed = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_setting);
        this.channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (this.channel == null || plugin == null) {
            this.finish();
            return;
        }
        this.setBigBar(plugin);
        this.initView();
    }

    private void setBigBar(Plugin plugin) {
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).build();
        this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        this.getBigBar().setTitleByKey("ch.settings.title");
        this.setStatusBarColor(plugin.getBackgroundColor());
    }

    private void initView() {
        this.findViewById(R.id.iv_channel_symbol).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.ch_button_setting_language).setOnClickListener((View.OnClickListener)this);
        CHTextView textVersion = (CHTextView)this.findViewById(R.id.tv_plugin_version);
        textVersion.setText("3.1.3");
        this.completed = PrefSupervisor.isShownClosedChat((Context)this);
        SwitchCompat switchCompleted = (SwitchCompat)this.findViewById(R.id.sw_show_closed_chat);
        switchCompleted.setChecked(this.completed);
        switchCompleted.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        SwitchCompat switchAlarm = (SwitchCompat)this.findViewById(R.id.sw_enable_alarm);
        switchAlarm.setChecked(PrefSupervisor.isEnabledPushAlarm((Context)this));
        switchAlarm.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.setLanguageSettingText();
    }

    private void setLanguageSettingText() {
        this.languageSettingText = (CHTextView)this.findViewById(R.id.ch_text_setting_language);
        String languageCode = PrefSupervisor.getPluginLanguage((Context)this);
        this.languageSettingText.setTextByKey(languageCode);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_channel_symbol) {
            Executor.goWeb((Context)this, this.getUrl());
        }
        if (id2 == R.id.ch_button_setting_language) {
            IntentUtils.setNextActivity((Context)this, SettingLanguageActivity.class).startActivityForResult(4000);
        }
    }

    private String getUrl() {
        return String.format("https://channel.io/%s/?utm_source=%s&utm_medium=plugin&utm_campaign=android&utm_content=%s&utm_channel_id=%s", PrefSupervisor.getPluginLanguage((Context)this), "plugin_exposure", this.channel.getName(), this.channel.getId());
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int id2 = buttonView.getId();
        if (id2 == R.id.sw_show_closed_chat) {
            this.handleShowClosedChat(isChecked);
        }
        if (id2 == R.id.sw_enable_alarm) {
            PrefSupervisor.setPushAlarm((Context)this, isChecked);
        }
    }

    private void handleShowClosedChat(boolean isChecked) {
        if (this.completed == isChecked) {
            this.setResult(0);
        } else {
            this.setResult(23);
        }
        PrefSupervisor.setShowClosedChat((Context)this, isChecked);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 4000 && resultCode == 30) {
            this.languageSettingText.setTextByKey(PrefSupervisor.getPluginLanguage((Context)this));
        }
    }

    @Override
    @AnimRes
    protected int getEnterAnimOfCreate() {
        return R.anim.ch_plugin_slide_in_bottom;
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        return R.anim.ch_plugin_slide_out_bottom;
    }
}

